<?php $__env->startSection('title', 'NewsList'); ?>


<?php $__env->startSection('breadcrumb-title'); ?>
    <h3>News List</h3>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<style>
    .dt-search{
        float:right;
    }
    svg.w-5.h-5 {
    width: 20px !important;
    height: 20px !important;
    display: none;
}

span.relative.z-0 {
    display: flex;
    justify-content: flex-end;
    align-content: center;
    align-items: center;
    flex-wrap: nowrap;
    display: none;

}
/* .flex.justify-between.flex-1.sm\:hidden {
    display: none;
} */

 </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('breadcrumb-items'); ?>
    <li class="breadcrumb-item">News</li>
    <li class="breadcrumb-item active">News List</li>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="container-fluid basic_table">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <a class="btn btn-primary btn-sm pull-right" href="<?php echo e(route('admin.add-news')); ?>"
                            data-bs-original-title="" title=""><i class="fa fa-plus"></i> Add News & Insights</a>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table  table-striped table-bordered " id="NewsTable">
                                <thead class="table-dark">
                                    <tr>
                                    <!-- <th>#</th> -->
                                    <th>Image</th>
                                    <th>Title</th>
                                    <th>Category</th>
                                    <th>News Date</th>
                                    <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                    <!-- <td><?php echo e(($news->currentPage() - 1) * $news->perPage() + $loop->iteration); ?></td> -->
                                    <td>
                                        <a target="_blank">
                                            <img src="<?php echo e(asset('assets/news/' . $item->image)); ?>" style="width:150px;height:150px;object-fit:cover;"  />
                                        </a></td>
                                        <td><?php echo e($item->title); ?></td>
                                        <td><?php echo e($item->category->category_name ?? 'Uncategorized'); ?></td>
                                        <td><?php echo e(\Carbon\Carbon::parse($item->news_date)->format('d M Y')); ?></td>
                                        <td>
                                            <ul class="action">
                                                <li class="edit"><a href="<?php echo e(route('admin.update-news', $item->id)); ?>"><i class="icon-pencil-alt"></i></a></li>
                                                <li class="delete"><a onclick="return confirmDelete();"
                                                                            href="<?php echo e(route('admin.delete-news',  $item->id)); ?>"
                                                                            data-bs-original-title="" title=""><i
                                                                                class="icon-trash"></i></a></li>
                                                </ul>
                                            
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="3" class="text-center">No news found</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                            </table>  
                            <!-- <?php echo $news->links(); ?> -->
                            <div class="flex justify-center mt-4">
                                <?php echo $news->links(); ?>

                            </div>
                         </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $("#NewsTable").DataTable();

        function confirmDelete() {
            return confirm('Are you sure you want to delete this News Item?');
        }
    </script>
  
     
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.simple.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/caferoute66/public_html/dovehouse/resources/views/admin/news/list.blade.php ENDPATH**/ ?>