<?php if(isset($user)): ?>
<?php $__env->startSection('title', 'Update Customer'); ?>
<?php else: ?>
<?php $__env->startSection('title', 'Create News'); ?>
<?php endif; ?>

<?php $__env->startSection('css'); ?>
    <style>
        /* .avatar-preview>div {
            width: 100%;
            height: 100%;
            border-radius: 50%;
            background-size: cover;
            background-repeat: no-repeat;
            background-position: top;
        } */

        .form-group {
            margin-bottom: 20px; /* Increased spacing */
        }

        .card {
            padding: 20px;
        }

        .ck-editor__editable {
            min-height: 250px; /* Increased height for better usability */
        }

        .remove-image-btn {
        background-color: red;
        color: white;
        border: none;
        padding: 5px;
        cursor: pointer;
        font-size: 12px;
        position: absolute;
        right: 5px;
        top: 5px;
    }
.text-start {
     margin-left: -25px !important;
}

    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-title'); ?>
    <?php if(isset($user)): ?>
        <h3>Edit Customer</h3>
    <?php else: ?>
        <h3>Create News</h3>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-items'); ?>
    <li class="breadcrumb-item">News</li>
    <?php if(isset($user)): ?>
        <li class="breadcrumb-item active">Edit Customer</li>
    <?php else: ?>
        <li class="breadcrumb-item active">Create News</li>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-10">
                <div class="card">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <div class="text-start">
                        <button type="button" class="btn btn-sm" onclick="history.back()">
                        <i class="icon-arrow-left"></i>
                        </button>
                    </div>

                    <div class="card-body">
                        <form id="AddForm" name="AddForm" action="<?php echo e(route('admin.news-info')); ?>" method="post"
                            enctype="multipart/form-data">

                            <input type="hidden" name="_token" id="_token" value="<?php echo e(csrf_token()); ?>">

                            <div class="form-group">
                                <label class="form-label required">Category</label>
                                <select name="category_id" id="category_id" class="form-control" required>
                                    <option value="">Select Category</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"><?php echo e($category->category_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <small class="text-danger"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group">
                                <label class="form-label required" for="title">News Title</label>
                                <input type="text" class="form-control" name="title" id="title"
                                    placeholder="Enter News Title">
                            </div>

                            <div class="form-group">
                                <label class="form-label required" for="image">News Image</label>
                                <input type="file" class="form-control" name="image" id="image">
                                <small class="text-muted">Only JPG, JPEG, GIF files allowed. Max size: 2MB.</small>
                            </div>

                            <div class="form-group text-center">
                                <img id="imagePreview" src='' width="100" height="80" class="img-thumbnail d-none">
                            </div>

                            <div class="form-group">
                                <label class="form-label required" for="short_description">News Short Description</label>
                                <textarea class="form-control" rows="6" name="short_description"
                                    id="short_description" placeholder="Enter short description"></textarea>
                            </div>

                            <div class="form-group">
                                <label class="form-label required" for="long_description">News Long Description</label>
                                <textarea id="long_description" name="long_description" class="form-control" rows="10"
                                    placeholder="Enter News Description"></textarea>
                            </div>

                            <div class="form-group">
                                <label class="form-label required" for="news_date">News Date</label>
                                <input class="form-control" type="date" id="news_date" name="news_date">
                            </div>

                            <div class="form-group text-center">
                                <button type="submit" id="SubmitBtn" class="btn btn-primary w-100">Save News & Insights</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<script src="https://cdn.ckeditor.com/ckeditor5/36.0.1/classic/ckeditor.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        ClassicEditor
            .create(document.querySelector('#long_description'), {
                toolbar: ['bold', 'italic', 'bulletedList', 'numberedList', 'imageUpload'],
                ckfinder: {
                    uploadUrl: "<?php echo e(route('admin.ckeditor.upload') . '?_token=' . csrf_token()); ?>",
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    }
                }
            })
            .then(editor => {
                window.editor = editor;

                // Load existing content if editing
                let existingContent = `<?php echo old('long_description', $news->long_description ?? ''); ?>`;
                editor.setData(existingContent);
                
                // Listen for image uploads
                editor.plugins.get('FileRepository').on('change:uploaded', () => {
                    alert("Image Uploaded Successfully!");
                });

                // Handle Remove Image Button
                editor.model.document.on('change:data', () => {
                    setTimeout(() => {
                        document.querySelectorAll(".image-inline.ck-widget.image").forEach(imgElement => {
                            if (!imgElement.querySelector(".remove-image-btn")) {
                                let removeButton = document.createElement("button");
                                removeButton.classList.add("remove-image-btn");
                                removeButton.innerText = "Remove";
                                removeButton.addEventListener("click", function () {
                                    imgElement.remove();
                                    alert("Image Removed Successfully!");
                                });
                                imgElement.appendChild(removeButton);
                            }
                        });
                    }, 500);
                });
            })
            .catch(error => console.error('CKEditor Error:', error));
    });
</script>

<script>

    $(document).ready(function () {
        $("#image").change(function () {
            var input = this;
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function (e) {
                    $('#imagePreview').attr('src', e.target.result).removeClass('d-none');
                }
                reader.readAsDataURL(input.files[0]);
            }
        });

        let today = new Date().toISOString().split('T')[0];
        document.getElementById("news_date").value = today;
    });
</script>

<script>
    $(document).ready(function () {

    function validateField(field, condition, message) {
    let errorSpan = field.next(".text-danger");

    if (condition) {
        errorSpan.remove(); // Remove error if valid
    } else {
        if (errorSpan.length === 0) {
            field.after(`<span class="text-danger">${message}</span>`);
        }
    }
}

$("#SubmitBtn").click(function (event) {
    event.preventDefault();
    let isValid = true;
    $(".text-danger").remove();

    let category = $("#category_id");
    if (category.val() === "") {
        validateField(category, false, "Category is required.");
        isValid = false;
    } else {
        validateField(category, true, "");
    }

    let title = $("#title");
    if (title.val().trim().length < 5) {
        validateField(title, false, "News Title must be at least 5 characters.");
        isValid = false;
    } else {
        validateField(title, true, "");
    }

    let image = $("#image");
    let imageVal = image.val();
    let validExtensions = ["jpg", "jpeg", "gif"];
    let fileExtension = imageVal.split('.').pop().toLowerCase();
    if (imageVal === "" || !validExtensions.includes(fileExtension)) {
        validateField(image, false, "Invalid image format. Only JPG, JPEG, and GIF allowed.");
        isValid = false;
    } else {
        validateField(image, true, "");
    }

    let shortDesc = $("#short_description");
    if (shortDesc.val().trim().length < 20) {
        validateField(shortDesc, false, "Short Description must be at least 20 characters.");
        isValid = false;
    } else {
        validateField(shortDesc, true, "");
    }

    let longDesc = window.editor.getData().trim();
    let longDescField = $("#long_description");
    if (longDesc.length < 50) {
        validateField(longDescField, false, "Long Description must be at least 50 characters.");
        isValid = false;
    } else {
        validateField(longDescField, true, "");
    }

    let newsDate = $("#news_date");
    if (newsDate.val() === "") {
        validateField(newsDate, false, "News Date is required.");
        isValid = false;
    } else {
        validateField(newsDate, true, "");
    }

    if (isValid) {
        $("#AddForm").submit();
    }
});

// Remove errors when the user corrects input
$("#category_id, #title, #short_description, #news_date").on("input change", function () {
    validateField($(this), true, "");
});

$("#image").change(function () {
    let imageVal = $(this).val();
    let validExtensions = ["jpg", "jpeg", "gif"];
    let fileExtension = imageVal.split('.').pop().toLowerCase();

    if (imageVal !== "" && validExtensions.includes(fileExtension)) {
        validateField($(this), true, "");
    }
});

window.editor.model.document.on('change:data', () => {
    let longDesc = window.editor.getData().trim();
    let longDescField = $("#long_description");

    if (longDesc.length >= 50) {
        validateField(longDescField, true, "");
    }
});

});

</script>

<?php echo $__env->make('layouts.simple.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/caferoute66/public_html/dovehouse/resources/views/admin/news/create.blade.php ENDPATH**/ ?>