<?php $__env->startSection('title', 'Login'); ?>

<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
    <style>
        .login-card .login-main .theme-form .show-hide {
            top: 70% !important;
        }

        img {
            width: 250px;
            height: auto !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php
        $siteSocialMedia = \App\Models\SiteSettings::where('type', 'social_media')->get();

        // Set static logo path
        $logo = asset('assets/images/logo/login-logo.svg');

        $favIcon =
            !empty($site->fav_icon) && Storage::exists($site->fav_icon)
            ? asset(Storage::url($site->fav_icon))
            : asset('frontend/assets/images/favicon.png');
    ?>
    <div class="container-fluid p-0">
        <div class="row m-0">
            <div class="col-12 p-0">
                <div class="login-card">
                    <div>
                        <div>
                            <h1><a class="logo">
                                    <img class="img-fluid for-light" src="<?php echo e($logo); ?>" alt="log-in page">
                                </a></h1>
                        </div>
                        <div class="login-main">
                            <?php echo $__env->make('layouts.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <form class="theme-form" method="POST" action="<?php echo e(route('login.access')); ?>">
                                <?php echo csrf_field(); ?>
                                <!-- <input type="hidden" name="_token" id="_token" value="<?php echo e(csrf_token()); ?>"> -->

                                <h4 style="color: #203468; font-weight: bold;">Sign in to account</h4>
                                <p>Enter your email & password to login</p>
                                <div class="form-group">
                                    <label class="col-form-label">Email Address</label>
                                    <input class="form-control" name="username" type="text" required=""
                                        placeholder="Enter email.">
                                    <?php if($errors->has('username')): ?>
                                        <span class="text-danger"><?php echo e($errors->first('username')); ?></span>
                                    <?php endif; ?>
                                </div>
                                <div class="form-group">
                                    <label class="col-form-label">Password</label>
                                    <input class="form-control" name="password" type="password" required=""
                                        placeholder="Enter your login password.">
                                    <div class="show-hide"><span class="show"style="color:#203468;"> </span></div>
                                    <?php if($errors->has('password')): ?>
                                        <span class="text-danger"><?php echo e($errors->first('password')); ?></span>
                                    <?php endif; ?>
                                </div>
                                <div class="form-group mb-0">
                                    <div class="mt-5 text-center">
                                        <button class="btn btn-primary btn-block custom_btn_black" type="submit">SIGN IN
                                            </button>
                                    </div>
                                </div>
                            </form>
                            <div>
                            <!-- <a class="link" href="<?php echo e(route('forget-password')); ?>">Forgot password?</a> -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    setInterval(function () {
        fetch("<?php echo e(route('session.check')); ?>")
            .then(response => response.json())
            .then(data => {
                console.log(data);
                if (!data.active) {
                   console.log("Session expired! Reloading...");
                    location.reload();
                }
            })
            .catch(error => console.error("Session check failed", error));
    }, 60000); // Check every 60 seconds
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.authentication.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/caferoute66/public_html/dovehouse/resources/views/auth/login.blade.php ENDPATH**/ ?>