<?php $__env->startSection('css'); ?>
    <style>
        .avatar-preview>div {
            width: 100%;
            height: 100%;
            border-radius: 50%;
            background-size: cover;
            background-repeat: no-repeat;
            background-position: top;
        }

        .form-group {
            margin-bottom: 15px;
            /* Adds space between inputs */
        }

        .text-start {
            margin-left: -25px !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/animate.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/plugin/jquery_filer/css/jquery.filer.css')); ?>">
    <link href="<?php echo e(asset('assets/plugin/jquery_filer/css/themes/jquery.filer-dragdropbox-theme.css')); ?>" type="text/css"
        rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-title'); ?>
        <h3>Add Category</h3>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-items'); ?>
        <li class="breadcrumb-item">Category</li>
        <li class="breadcrumb-item active">Add Category</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row">
            <div class="card">
                <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>


                
                <div class="row">

                
                    <!-- Left Side: Form -->
                    <div class="col-lg-6 col-md-12">
                        <div class="card">
                            <div class="text-start">
                                    <button type="button" class="btn btn-sm" onclick="history.back()">
                                    <i class="icon-arrow-left"></i>
                                    </button>
                            </div>

                            <div class="card-body">
                                <div class="basic-form">
                                    <form id="AddForm" name="AddForm" action="<?php echo e(route('admin.category-info')); ?>" method="post"
                                        enctype="multipart/form-data">

                                        <input type="hidden" name="_token" id="_token" value="<?php echo e(csrf_token()); ?>">

                                        <div class="form-group mb-3">
                                            <label class="form-label required" for="category_name">Category Name</label>
                                            <input type="text" class="form-control" name="category_name" id="category_name"
                                                placeholder="Enter Category Name">
                                        </div>

                                        <div class="form-group mb-3">
                                            <button type="submit" id="SubmitBtn" class="btn btn-primary">Save</button>
                                        </div>

                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function () {

        function validateField(field, condition, message) {
            let errorSpan = field.next(".text-danger");

            if (condition) {
                errorSpan.remove(); // Remove error if valid
            } else {
                if (errorSpan.length === 0) {
                    field.after(`<span class="text-danger">${message}</span>`);
                }
            }
        }

        $("#SubmitBtn").click(function (event) {
            event.preventDefault();
            let isValid = true;
            $(".text-danger").remove(); // Clear previous error messages

            // Validate Category Name
            let categoryName = $("#category_name");
            if (categoryName.val().trim().length < 3) {
                validateField(categoryName, false, "Category Name must be at least 3 characters.");
                isValid = false;
            } else {
                validateField(categoryName, true, "");
            }

            // If all fields are valid, submit the form
            if (isValid) {
                $("#AddForm").submit();
            }
        });

        // Remove errors when the user starts typing
        $("#category_name").on("input", function () {
            validateField($(this), true, "");
        });

    });
</script>

<?php echo $__env->make('layouts.simple.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/caferoute66/public_html/dovehouse/resources/views/admin/categories/create.blade.php ENDPATH**/ ?>