<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\IndexController;
use App\Http\Controllers\Admin as Admin;
use App\Http\Controllers\Application;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\WebhookController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\RolesController;
use App\Http\Controllers\Admin\SettingsController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\Application\HomeController;
use App\Http\Controllers\Application\ContestController;
use App\Http\Controllers\Application\CheckoutController;
use App\Http\Controllers\Application\SocialLoginController;
use App\Http\Controllers\Application\AuthController as FrontAuthController;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Admin\ContactController;
use App\Http\Controllers\Admin\AboutUsController;
use App\Http\Controllers\Admin\HomepageController;
use App\Http\Controllers\Admin\MasterController;
use App\Http\Controllers\Admin\NewsController;
use App\Http\Controllers\Admin\CategoryController;



/*Route::get('/', function () {
    return view('welcome');
})->name('/');*/

Route::get('/login', [AuthController::class, 'index'])->name('login');
Route::get('/register', [AuthController::class, 'register'])->name('register');
Route::post('/user-register', [AuthController::class, 'userRegistration'])->name('user.registration');
Route::post('/login', [AuthController::class, 'loginAccess'])->name('login.access');
Route::get('/forget-password', [AuthController::class, 'forgetPassword'])->name('forget-password');
Route::post('/forget-password', [AuthController::class, 'forgetPasswordRequest'])->name('forget-password.save');
Route::get('/reset-password/{token}', [AuthController::class, 'resetPassword'])->name('reset-password');
Route::post('/reset-password', [AuthController::class, 'resetPasswordRequest'])->name('reset-password.save');
Route::post('/edit-profile/{id}', [AuthController::class, 'EditProfile'])->name('edit-profile');


Route::get('/logout', [AuthController::class, 'logout'])->name('logout');

Route::middleware(['admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [IndexController::class, 'adminDashboard'])->name('dashboard');

    Route::prefix('site-settings')->group(function () {
        Route::get('/{id}', [SettingsController::class, 'createOrEditSettings'])->name('settings.site');
        Route::post('/save', [SettingsController::class, 'saveSettings'])->name('settings.site.save');
        // Route::post('/update', [SettingsController::class, 'updateSettings'])->name('settings.site.update');
        
    });
    Route::post('/update-user-profile', [UserController::class, 'updateProfile'])->name('update-user-profile');
    Route::post('/update-user-password', [UserController::class, 'UpdateAdminPassword'])->name('update-user-password');

    Route::get('/create-role', [RolesController::class, 'create'])->name('create-role');
    Route::post('/store-role', [RolesController::class, 'store'])->name('store-role');
    Route::get('/roles', [RolesController::class, 'index'])->name('roles');

    // Contest Management
    Route::prefix('contest-management')->group(function () {
        Route::get('/', [Admin\ContestController::class, 'index'])->name('contests');
        Route::get('/create-contest', [Admin\ContestController::class, 'create'])->name('create-contest');
        Route::get('/edit-contest/{id}', [Admin\ContestController::class, 'update'])->name('update-contest');
        Route::post('/update-contest', [Admin\ContestController::class, 'updateContest'])->name('update-contest-details');
        Route::get('/delete-contest/{id}', [Admin\ContestController::class, 'delete'])->name('delete-contest');
        Route::get('/image-delete-contest', [Admin\ContestController::class, 'imageDelete'])->name('image-delete');
        Route::post('/store-contest', [Admin\ContestController::class, 'store'])->name('store-contest');
        Route::get('/featured-contests', [Admin\ContestController::class, 'featured'])->name('featured-contests');
        Route::get('/edit-featured-contests/{id}', [Admin\ContestController::class, 'editFeatured'])->name('edit-featured-contests');
        Route::post('/update-featured', [Admin\ContestController::class, 'updateFeaturedContest'])->name('update-featured');
    });

    // Customers
    Route::prefix('customers')->group(function () {
        Route::get('/list', [Admin\CustomerController::class, 'index'])->name('customers');
        Route::get('/create-customer', [Admin\CustomerController::class, 'add'])->name('add-customer');
        Route::get('/edit/{id}', [Admin\CustomerController::class, 'update'])->name('update-customer');
        Route::get('/deactivated-list', [Admin\CustomerController::class, 'deactivatedList'])->name('customers.deactivated.list');


        // Questions & Answers
        Route::prefix('question-answer')->group(function () {
            Route::get('/', [Admin\QuestionsController::class, 'index'])->name('questions-list');
            Route::get('/create', [Admin\QuestionsController::class, 'add'])->name('create-question');
            Route::get('/edit/{questionId}', [Admin\QuestionsController::class, 'updateView'])->name('update-question');
            Route::post('/store', [Admin\QuestionsController::class, 'store'])->name('store-question');
            Route::post('/update', [Admin\QuestionsController::class, 'update'])->name('update-question-data');
            Route::get('/delete/{questionId}', [Admin\QuestionsController::class, 'deleteQuestion'])->name('delete-question');
        });
    });

    //News Routes
    Route::prefix('news')->group(function () {
        Route::get('/list', [Admin\NewsController::class, 'index'])->name('news');
        Route::get('/create-news', [Admin\NewsController::class, 'add'])->name('add-news');
        Route::post('/update-news-info', [Admin\NewsController::class, 'createNews'])->name('news-info');
        Route::get('/edit/{id}', [Admin\NewsController::class, 'edit'])->name('update-news');
        Route::get('/delete-news/{id}', [Admin\NewsController::class, 'delete'])->name('delete-news');
        Route::post('/update-newsdata/{id}', [Admin\NewsController::class, 'update'])->name('update-newsdata');
        Route::post('/ckeditor/upload', [Admin\NewsController::class, 'uploadImage'])->name('ckeditor.upload');
        
    });

    // Category Routes
   
    Route::prefix('categories')->group(function () {
        Route::get('/list', [Admin\CategoryController::class, 'index'])->name('categories');     
        Route::get('/create-category', [Admin\CategoryController::class, 'add'])->name('add-category');
        Route::post('/create-category-info', [Admin\CategoryController::class, 'createCategory'])->name('category-info');
        Route::get('/edit/{id}', [Admin\CategoryController::class, 'editCategory'])->name('edit-category');
        Route::post('/update-category/{id}', [Admin\CategoryController::class, 'updateCategory'])->name('update-category');        


    });

    // Ticket Management
    Route::prefix('tickets-management')->group(function () {
        Route::get('/', [Admin\TicketsController::class, 'index'])->name('tickets-list');
    });

    // Transactions
    Route::prefix('transactions-management')->group(function () {
        Route::get('/', [Admin\TransactionsController::class, 'index'])->name('transactions-list');
    });

    // NewsLetters
    Route::prefix('newsletter-management')->group(function () {
        Route::get('/', [Admin\SubscribersController::class, 'index'])->name('subscribers-list');
    });


    // User Management
    Route::prefix('user-management')->group(function () {
        Route::get('/users-list', [UserController::class, 'index'])->name('users');
        Route::get('/create-user', [UserController::class, 'create'])->name('create-user');
        Route::get('/edit-user/{id}', [UserController::class, 'edit'])->name('update-user');
        Route::post('/store-user', [UserController::class, 'store'])->name('store-user');
        Route::get('/delete-user/{id}/{type}', [UserController::class, 'delete'])->name('delete-user');
        Route::get('/delete-user/restore/{id}/{type}', [UserController::class, 'restoreDeleteRecord'])->name('delete-user.restore');

        Route::get('/deactivated-users-list', [UserController::class, 'deactivatedList'])->name('users.deactivated.list');
    });

    Route::post('/update-user-info', [Admin\CustomerController::class, 'createOrUpdateUser'])->name('update-info');




    Route::post('/declare-winner', [Admin\TicketsController::class, 'declareWinner'])->name('declare-winner');
    Route::get('/view-more-ticket-details', [Admin\TicketsController::class, 'viewMoreTicketDetails'])->name('more-ticket-details');



    Route::prefix('cms')->group(function () {

        Route::prefix('homepage')->name('homepage.')->group(function () {
            Route::get('/', [HomepageController::class, 'index'])->name('index');
            Route::post('/store', [HomepageController::class, 'store'])->name('store');
        });

        Route::prefix('contact-us')->name('contact_us.')->group(function () {
            Route::get('/', [ContactController::class, 'dynamicIndex'])->name('dynamic.index');
            Route::post('/store', [ContactController::class, 'dynamicStore'])->name('dynamic.store');

            Route::get('/enquiry', [ContactController::class, 'receivedRequests'])->name('received.requests');
        });

        Route::prefix('about-us')->name('about_us.')->group(function () {
            Route::get('/', [AboutUsController::class, 'index'])->name('index');
            Route::post('/store', [AboutUsController::class, 'store'])->name('store');

            Route::prefix('testimonials')->name('testimonial.')->group(function () {
                Route::get('/', [AboutUsController::class, 'testimonialIndex'])->name('index');
                Route::get('/create', [AboutUsController::class, 'testimonialCreate'])->name('create');
                Route::post('/store', [AboutUsController::class, 'testimonialStore'])->name('store');
                Route::get('/edit/{id}', [AboutUsController::class, 'testimonialEdit'])->name('edit');
                Route::post('/update/{id}', [AboutUsController::class, 'testimonialUpdate'])->name('update');
                Route::get('/delete/{id}', [AboutUsController::class, 'testimonialDelete'])->name('delete');
            });

            Route::prefix('team-members')->name('team.')->group(function () {
                Route::get('/', [AboutUsController::class, 'teamIndex'])->name('index');
                Route::get('/create', [AboutUsController::class, 'teamCreate'])->name('create');
                Route::post('/store', [AboutUsController::class, 'teamStore'])->name('store');
                Route::get('/edit/{id}', [AboutUsController::class, 'teamEdit'])->name('edit');
                Route::post('/update/{id}', [AboutUsController::class, 'teamUpdate'])->name('update');
                Route::get('/delete/{id}', [AboutUsController::class, 'teamDelete'])->name('delete');
            });
        });

        Route::prefix('terms-conductions')->name('master.')->group(function () {
            Route::get('/', [MasterController::class, 'termServices'])->name('term.services');
            Route::post('/store', [MasterController::class, 'termServiceSave'])->name('term.services.save');
        });

        Route::prefix('privacy-policy')->name('master.')->group(function () {
            Route::get('/', [MasterController::class, 'privacy'])->name('privacy');
            Route::post('/store', [MasterController::class, 'privacySave'])->name('privacy.save');
        });

        Route::prefix('disclaimer')->name('master.')->group(function () {
            Route::get('/', [MasterController::class, 'disclaimer'])->name('disclaimer');
            Route::post('/store', [MasterController::class, 'disclaimerSave'])->name('disclaimer.save');
        });

        Route::prefix('faqs')->name('faqs.')->group(function () {

            Route::get('/', [Admin\FAQsController::class, 'index'])->name('faqs-list');
            Route::get('/create-faq', [Admin\FAQsController::class, 'add'])->name('create-faq');
            Route::post('/store-faqs', [Admin\FAQsController::class, 'store'])->name('store-faqs');
            Route::get('/update-faqs/{category_id}', [Admin\FAQsController::class, 'updateView'])->name('update-faqs');
            Route::post('/update-faq', [Admin\FAQsController::class, 'update'])->name('update-faq');
            Route::delete('/delete-faq', [Admin\FAQsController::class, 'delete'])->name('delete-faq');

            Route::get('/create-faq-category', [Admin\FAQsController::class, 'addCategory'])->name('create-faq-category');
            Route::post('/store-faq-category', [Admin\FAQsController::class, 'storeCategory'])->name('store-faq-category');
            Route::get('/faq-categories', [Admin\FAQsController::class, 'faqCategoriesList'])->name('faq-categories');
            Route::get('/update-faq-category/{id}', [Admin\FAQsController::class, 'updateCategoryView'])->name('update-faq-category-view');
            Route::post('/update-faq-category', [Admin\FAQsController::class, 'updateCategory'])->name('update-faq-category');
            Route::get('/delete-faq-category', [Admin\FAQsController::class, 'deleteFAQCategory'])->name('delete-faq-category');
        });
    });
});

/* Front End Application Routes */
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/about-us', [HomeController::class, 'aboutUs'])->name('about-us');
Route::get('/contact-us', [HomeController::class, 'contactUs'])->name('contact-us');
Route::post('/contact-us/save-request', [HomeController::class, 'contactUsRequestSave'])->name('contact-us.save');
Route::get('/faqs', [HomeController::class, 'faq'])->name('faq');

Route::get('/all-competitions', [ContestController::class, 'contestListing'])->name('contest-listing');
Route::get('/contest-details/{id}/{slug}', [ContestController::class, 'contestDetails'])->name('contest-details');

Route::post('/subscribers/request', [HomeController::class, 'subscribers'])->name('subscribers.request');

Route::get('/terms-and-conditions', [HomeController::class, 'termServices'])->name('term.services');
Route::get('/privacy-policy', [HomeController::class, 'privacy'])->name('privacy');
Route::get('/disclaimer', [HomeController::class, 'disclaimer'])->name('disclaimer');

// Auth Routes
Route::prefix('auth')->name('frontend.')->group(function () {
    Route::get('/login', [FrontAuthController::class, 'login'])->name('login');
    Route::post('/login-access', [FrontAuthController::class, 'loginUserAccess'])->name('login-access');
    Route::post('/register/store', [FrontAuthController::class, 'saveRegisterUserDetails'])->name('register-account.store');

    Route::get('/register-account/verify/{token}', [FrontAuthController::class, 'verifyAccount'])->name('register.verify.account');

    Route::prefix('forget-password')->name('forget-password.')->group(function () {
        Route::get('/', [FrontAuthController::class, 'forgetPassword'])->name('index');
        Route::post('/store', [FrontAuthController::class, 'forgetPasswordRequestStore'])->name('store');
        Route::get('/verify/{token}', [FrontAuthController::class, 'forgetPasswordVerifyToken'])->name('verify.token');
        Route::post('/update/new-password', [FrontAuthController::class, 'forgetedUpdateNewPassword'])->name('update.password');
    });

    Route::get('/{provider}/redirect', [SocialLoginController::class, 'redirect'])->name('auth.socialite.redirect');
    Route::get('/{provider}/callback', [SocialLoginController::class, 'callback'])->name('auth.socialite.callback');
});

Route::name('frontend.')->group(function () {
    Route::get('/cart', [CheckoutController::class, 'cart'])->name('cart');
    Route::post('/add-To-cart', [CheckoutController::class, 'addItemsToCart'])->name('add.cart');
    Route::get('/get-cart/items', [CheckoutController::class, 'getCartItems'])->name('get.cart');
    Route::get('/empty-cart', [CheckoutController::class, 'emptyCartItems'])->name('empty.cart.items');
    Route::get('/delete-cart/{id}', [CheckoutController::class, 'deleteCartItem'])->name('delete.cart.item');

    Route::get('/make-unmake-fav', [HomeController::class, 'makeOrUnmakeFav'])->name('make.unmake.fav');
});

Route::middleware(['auth'])->prefix('user')->name('frontend.user.')->group(function () {

    Route::get('/checkout-cart', [CheckoutController::class, 'checkoutCart'])->name('checkout.cart');

    Route::get('/personal-information', [HomeController::class, 'dashboard'])->name('dashboard');
    Route::get('/tickets', [HomeController::class, 'tickets'])->name('tickets');
    Route::get('/transactions', [HomeController::class, 'transactions'])->name('transactions');
    Route::get('/referral-program', [HomeController::class, 'referralProgram'])->name('referral-program');
    Route::get('/favorite-lottery', [HomeController::class, 'favoriteLottery'])->name('favorite-lottery');

    Route::post('/update-user-info', [Application\AccountController::class, 'updateUserInfo'])->name('update-info');

    Route::get('/logout', [FrontAuthController::class, 'logout'])->name('logout');

    Route::get('/get-questions', [HomeController::class, 'getQuestionToAnswer'])->name('get.questions');
    Route::post('/user-answer', [HomeController::class, 'saveUserQuestionAnswer'])->name('save.question.answer');
    


    // Checkout
    Route::prefix('checkout')->name('checkout.')->group(function () {
        Route::post('/', [PaymentController::class, 'checkout'])->name('index');
        // Route::get('/success', [PaymentController::class, 'success'])->name('success');
        // Route::get('/cancel', [PaymentController::class, 'cancel'])->name('cancel');
        Route::post('/webhook', [PaymentController::class, 'webhook'])->name('webhook');

        Route::get('/success/{order}/{session}', [PaymentController::class, 'successDetails'])->name('success.details');
    });
});

Route::middleware(['auth'])->name('frontend.user.')->group(
    function () {
        // Checkout
        Route::prefix('checkout')->name('checkout.')->group(function () {
            Route::get('/success', [PaymentController::class, 'success'])->name('success');
            Route::get('/cancel', [PaymentController::class, 'cancel'])->name('cancel');
        });
    }
);

Route::get('viva/webhooks', [WebhookController::class, 'verify']);
Route::post('viva/webhooks', [WebhookController::class, 'handle']);

/* **************************** */

Route::get('/clear-cache', function () {
    Artisan::call('config:cache');
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    Artisan::call('view:clear');
    Artisan::call('route:clear');
    return "Cache is cleared";
})->name('clear.cache');

Route::get('/storage-link', function () {
    Artisan::call('storage:link');
    return "Storage linked";
})->name('storage.link');

Route::get('/migrate-refresh', function () {
    Artisan::call('migrate:fresh --seed');
    return "Migration Refreshed";
})->name('migrate.fresh');

Route::get('/migrate', function () {
    Artisan::call('migrate');
    return "Migration Run";
})->name('migrate');

Route::get('/swagger', function () {
    Artisan::call('l5-swagger:generate');
    return "Swagger Refreshed";
})->name('generate.swagger');

Route::get('/run-scheduler', function () {
    Artisan::call('send:draw-mail');
    return "Scheduler Run";
})->name('scheduler.run');

Route::get('/session-check', function () {
    return response()->json(['active' => auth()->check()]);
})->name('session.check');
