@php
    $site = \App\Models\SiteSettings::where('type', 'site_details')->first();
    $siteSocialMedia = \App\Models\SiteSettings::where('type', 'social_media')->get();

    $logo =
        !empty($site->logo) && Storage::exists($site->logo)
            ? asset(Storage::url($site->logo))
            : asset('assets/images/logo/logo-white.png');

    $favIcon =
        !empty($site->fav_icon) && Storage::exists($site->fav_icon)
            ? asset(Storage::url($site->fav_icon))
            : asset('frontend/assets/images/favicon.png');
@endphp
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />

    <title>@yield('title') : : {{ $site->title ?? 'BMF Competitions' }}</title>
    <!-- site favicon -->
    <link rel="icon" type="image/png" href="{{ $favIcon }}" sizes="16x16" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css"
        integrity="sha512-5A8nwdMOWrSz20fDsjczgUidUBR8liPYU+WymTZP1lmY9G6Oc7HlZv156XqnsgNUzTyMefFTcsFH/tnJE/+xBg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    @include('layouts.frontend.css')
    @yield('css')
    @yield('style')
</head>

<body>
    <input type="hidden" value="{{ route('frontend.get.cart', ['user_id' => request()->user()->id ?? 0]) }}"
        id="getCartItemsURL" />
    @include('layouts.frontend.loader')
    <!-- scroll-to-top start -->
    <div class="scroll-to-top">
        <span class="scroll-icon">
            <i class="las la-arrow-up"></i>
        </span>
    </div>
    <!-- scroll-to-top end -->

    <!-- content start-->
    <div class="page-wrapper">
        <!-- header start-->
        @include('layouts.frontend.nav_bar', ['logo' => $logo])
        <!-- header end-->

        @include('layouts.alerts')

        @yield('content')

        <!-- footer section start  -->
        @include('layouts.frontend.footer')
        <!-- footer section end -->
    </div>

    {{-- Models PopUps --}}
    @include('application.components.login')
    @include('application.components.register')
    @include('application.components.forget-password')
    @include('application.components.questions-popup')

    <!-- latest jquery-->
    @include('layouts.frontend.script')
    @include('layouts.frontend.cookies')

    @yield('script')
    <script>
        function showModal(openModalId, closeOtherModals) {
            $(closeOtherModals).modal('hide');
            $(openModalId).modal({
                show: true,
                // backdrop: "static",
                // keyboard: false
            });
        }

        $(document).on('click', '#showSignUpModalButton', function() {
            showModal('#signUpModal', '#loginModal, #forgetPasswordModal');
        });

        $(document).on('click', '#showLoginModalButton, #fpShowLoginModalButton', function() {
            showModal('#loginModal', "#signUpModal, #forgetPasswordModal");
        });

        $(document).on('click', '#showForgetPasswordModalButton', function() {
            showModal('#forgetPasswordModal', "#signUpModal, #forgetPasswordModal");
        });

        $(document).ready(function() {

            // Add event listeners for modal show and hide
            $('#loginModal, #signUpModal, #forgetPasswordModal').on('show.bs.modal', function() {
                $('body').addClass('modal-open');
            });

            // Check if any modal is still open when it's closed
            $('#loginModal, #signUpModal, #forgetPasswordModal').on('hidden.bs.modal', function() {
                if ($('.modal.show').length === 0) {
                    $('body').removeClass('modal-open');
                }
            });

            // If you have links or buttons inside the modals that open other modals, you can use similar event listeners
            $('.openSignUpModal').on('click', function() {
                showModal('#signUpModal', '#loginModal, #forgetPasswordModal');
            });

            $('.openLoginModal').on('click', function() {
                showModal('#loginModal', '#signUpModal, #forgetPasswordModal');
            });

            $('.openForgetPasswordModal').on('click', function() {
                showModal('#forgetPasswordModal', '#loginModal, #signUpModal');
            });
        });
    </script>
</body>

</html>
