<style>
    .cookies-eu-banner {
        background: #cc2474;
        color: #fff;
        padding: 6px;
        font-size: 13px;
        text-align: center;
        position: fixed;
        bottom: 0;
        width: 100%;
        z-index: 10;
    }

    .cookies-eu-banner button, .cookies-eu-banner a {
        text-decoration: none;
        background: #fff;
        color: #cc2474;
        border: 1px solid #fff;
        cursor: pointer;
        padding: 4px 7px;
        margin: 2px 0;
        font-size: 13px;
        font-weight: 700;
        transition: background 0.07s, color 0.07s, border-color 0.07s;
    }

    .cookies-eu-banner button:hover, .cookies-eu-banner a:hover {
        background: #fff;
        color: #0f0233;
    }

    .hidden {
        display: none;
    }
</style>
<div class="cookies-eu-banner">
  By clicking ”OK”, you agree to the storing of cookies on your device to
  enhance site navigation, analyze site usage, and improve marketing.
  <button>Accept</button>
  <a href="javascript:0;" id="decline">Decline</a>
</div>

<script>
    const getCookie = (name) => {
        const value = " " + document.cookie;
        console.log("value", `==${value}==`);
        const parts = value.split(" " + name + "=");
        return parts.length < 2 ? undefined : parts.pop().split(";").shift();
    };

    const setCookie = function (name, value, expiryDays, domain, path, secure) {
    const exdate = new Date();
    exdate.setHours(
        exdate.getHours() +
        (typeof expiryDays !== "number" ? 365 : expiryDays) * 24
    );
    document.cookie =
        name +
        "=" +
        value +
        ";expires=" +
        exdate.toUTCString() +
        ";path=" +
        (path || "/") +
        (domain ? ";domain=" + domain : "") +
        (secure ? ";secure" : "");
    };

    (() => {
        const $cookiesBanner = document.querySelector(".cookies-eu-banner");
        const $cookiesBannerButton = $cookiesBanner.querySelector("button");
        const $cookiesBannerAnchButton = $cookiesBanner.querySelector("a");

        $cookiesBannerButton.addEventListener("click", () => {
            $cookiesBanner.remove();
        });

        $cookiesBannerAnchButton.addEventListener("click", () => {
            $cookiesBanner.remove();
        });
    })();

    const $cookiesBanner = document.querySelector(".cookies-eu-banner");
    const $cookiesBannerButton = $cookiesBanner.querySelector("button");
    const $cookiesBannerAnchButton = $cookiesBanner.querySelector("a");
    const cookieName = "cookiesBanner";
    const hasCookie = getCookie(cookieName);
    if (!hasCookie) {
        $cookiesBanner.classList.remove("hidden");
    }

    $cookiesBannerAnchButton.addEventListener("click", () => {
        setCookie(cookieName, "declined");
        $cookiesBanner.remove();
    });

    $cookiesBannerButton.addEventListener("click", () => {
        setCookie(cookieName, "closed");
        $cookiesBanner.remove();
    });

    if(hasCookie === 'closed' || hasCookie === 'declined'){
        $cookiesBanner.remove();
    }
</script>