@php
  $site = \App\Models\SiteSettings::where('type', 'site_details')->first();
  $siteSocialMedia = \App\Models\SiteSettings::where('type', 'social_media')->get();

  $logo = (!empty($site->logo) && Storage::exists($site->logo))?asset(Storage::url($site->logo)):asset('assets/images/logo/logo-white.png');

  $favIcon = (!empty($site->fav_icon) && Storage::exists($site->fav_icon))?asset(Storage::url($site->fav_icon)):asset('frontend/assets/images/favicon.png');
@endphp
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title') : : BMF</title>
    <!-- site favicon -->
    <link rel="icon" type="image/png" href="{{$favIcon}}" sizes="16x16" />
    @include('layouts.frontend.css')
    @yield('css')
    @yield('style')
  </head>
  <body>
    <input type="hidden" value="{{route('frontend.get.cart', ['user_id' => request()->user()->id ?? 0])}}" id="getCartItemsURL" />
    @include('layouts.frontend.loader')
    <!-- scroll-to-top start -->
    <div class="scroll-to-top">
        <span class="scroll-icon">
            <i class="las la-arrow-up"></i>
        </span>
    </div>
    <!-- scroll-to-top end -->

    <!-- content start-->
    <div class="page-wrapper">
      <!-- header start-->
      {{-- @include('layouts.frontend.nav_bar') --}}
      <!-- header end-->

      @yield('content')

      <!-- footer section start  -->
      {{-- @include('layouts.frontend.footer') --}}
      <!-- footer section end -->
    </div>

    {{-- Models PopUps --}}
    @include('application.components.forget-password')
    @include('application.components.register')

    <!-- latest jquery-->
    @include('layouts.frontend.script')
    @yield('script')
  </body>
</html>
