@include('emails.header')
Hi {{ ucwords($data['ticketDetails']->customer->name) }}, </br>


<p>We're thrilled to announce that you are a winner in our latest draw! Congratulations on your fantastic win. Below are
    the details of your winning ticket:</p>

<div class="row">
    <ul>
        <li> Draw Name: <a
                href="{{ url('contest-details') }}/{{ $data['ticketDetails']->contest->id }}/{{ $data['ticketDetails']->contest->slug }}"
                target="_blank">{{ $data['ticketDetails']->contest->title }}</a> </li>
        <li> Winning Amount: - {{ config('app.currency_symbol') }}{{ $data['ticketDetails']->contest->winning_amount }}
        </li>
        <li> Draw Date: {{ date('d-m-Y', strtotime($data['ticketDetails']->contest->draw_date)) }} </li>
        <li> Draw Time: {{ date('H:i:s', strtotime($data['ticketDetails']->contest->draw_date)) }} </li>
    </ul>
</div>

@include('emails.components.contests')


<p>We're so excited for you and hope you enjoy your prize! If you have any questions or need further assistance, feel
    free to reach out to us at <a href="mailto:support@bmfcompetitions.eu">support@bmfcompetitions.eu</a></p>

<p>Thank you for participating in BMF Competitions. We appreciate your support and look forward to having you in our
    future draws.</p>

@include('emails.footer')
