@include('emails.header')

Hi {{ $data['user']?->name }}, <br />

Thank you for your recent ticket purchase! We're excited to have you participating in our
upcoming draw. Below are the details of your purchase: <br /><br />

<table style="width: 100%;" border="1" cellpadding="1">
    <thead>
        <tr>
            <td>Draw Name</td>
            <td>Total Tickets</td>
            <td>Ticket Numbers</td>
            <td>Amount</td>
            <td>Draw Date</td>
            <td>Draw Time</td>
        </tr>
    </thead>
    <tbody>
        @if (count($data['order']->items))
            @php
                $totalAmount = 0;
                $totalQuantity = 0;
                $totalContests = 0;
            @endphp
            @foreach ($data['order']->items as $key => $item)
                @php
                    $tickets = \DB::table('orders_tickets')
                        ->where(['order_id' => $item->order_id, 'contest_id' => $item->contest->id])
                        ->pluck('ticket_id')
                        ->toArray();
                @endphp
                <tr>
                    <td><a href="{{ url('contest-details') }}/{{ $item->contest->id }}/{{ $item->contest->slug }}"
                            target="_blank">{{ $item->contest->title }}</a></td>
                    <td>{{ $item->quantity }}</td>
                    <td>
                        @foreach ($tickets as $ticket)
                            {!! $ticket . '</br>' !!}
                        @endforeach
                    </td>
                    <td>{{ number_format($item->total, 2) }}</td>
                    <td>{{ !empty($item->contest->draw_date) ? date('Y-m-d', strtotime($item->contest->draw_date)) : ' - ' }}
                    </td>
                    <td>{{ strtoupper(!empty($item->contest->draw_date) ? date('H:m a', strtotime($item->contest->draw_date)) : ' - ') }}
                    </td>
                </tr>
                @php
                    $totalQuantity += $item->quantity;
                    $totalAmount += $item->total;
                @endphp
            @endforeach
            <tr>
                <td>{{ 'Total : ' }}</td>
                <td>{{ $totalQuantity }}</td>
                <td></td>
                <td>{{ number_format($totalAmount, 2) }}</td>
                <td></td>
                <td></td>
                <td></td>
            </tr>
        @else
            <tr>
                <td colspan="4">No Purchases Found</td>
            </tr>
        @endif
    </tbody>
</table>
<br /><br />

@include('emails.components.contests')

<br />

We wish you the best of luck in the draw and hope you win big! If you have any questions or
need further assistance, feel free to reach out to us at <a
    href="mailto:support@bmfcompetitions.eu">support@bmfcompetitions.eu</a>. <br /><br />

@include('emails.footer')
