@php
    $contests = \App\Models\Contests::where(function ($query) {
        $query->whereDate('contest_end', '>=', date('Y-m-d'));
    })->get();
@endphp

@if ($contests->count())
    <div>

        Here are a few upcoming draws you might be interested in:
        <ul>
            @foreach ($contests as $contest)
                <li>
                    <a
                        href="{{ route('contest-details', ['id' => $contest->id, 'slug' => $contest->slug]) }}">{{ $contest->title }}</a>
                </li>
            @endforeach

        </ul>

    </div>
@endif
