
@extends('layouts.authentication.master')
@section('title', 'Login')

@section('css')
@endsection

@section('style')
    <style>
        .login-card .login-main .theme-form .show-hide {
            top: 70% !important;
        }

        img {
            width: 250px;
            height: auto !important;
        }
    </style>
@endsection

@section('content')
    @php
        $siteSocialMedia = \App\Models\SiteSettings::where('type', 'social_media')->get();

        // Set static logo path
        $logo = asset('assets/images/logo/login-logo.svg');

        $favIcon =
            !empty($site->fav_icon) && Storage::exists($site->fav_icon)
            ? asset(Storage::url($site->fav_icon))
            : asset('frontend/assets/images/favicon.png');
    @endphp
    <div class="container-fluid p-0">
        <div class="row m-0">
            <div class="col-12 p-0">
                <div class="login-card">
                    <div>
                        <div>
                            <h1><a class="logo">
                                    <img class="img-fluid for-light" src="{{ $logo }}" alt="log-in page">
                                </a></h1>
                        </div>
                        <div class="login-main">
                            @include('layouts.alerts')
                            <form class="theme-form" method="POST" action="{{ route('login.access') }}">
                                @csrf
                                <!-- <input type="hidden" name="_token" id="_token" value="{{ csrf_token() }}"> -->

                                <h4 style="color: #203468; font-weight: bold;">Sign in to account</h4>
                                <p>Enter your email & password to login</p>
                                <div class="form-group">
                                    <label class="col-form-label">Email Address</label>
                                    <input class="form-control" name="username" type="text" required=""
                                        placeholder="Enter email.">
                                    @if ($errors->has('username'))
                                        <span class="text-danger">{{ $errors->first('username') }}</span>
                                    @endif
                                </div>
                                <div class="form-group">
                                    <label class="col-form-label">Password</label>
                                    <input class="form-control" name="password" type="password" required=""
                                        placeholder="Enter your login password.">
                                    <div class="show-hide"><span class="show"style="color:#203468;"> </span></div>
                                    @if ($errors->has('password'))
                                        <span class="text-danger">{{ $errors->first('password') }}</span>
                                    @endif
                                </div>
                                <div class="form-group mb-0">
                                    <div class="mt-5 text-center">
                                        <button class="btn btn-primary btn-block custom_btn_black" type="submit">SIGN IN
                                            </button>
                                    </div>
                                </div>
                            </form>
                            <div>
                            <!-- <a class="link" href="{{route('forget-password')}}">Forgot password?</a> -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
<script>
    setInterval(function () {
        fetch("{{ route('session.check') }}")
            .then(response => response.json())
            .then(data => {
                console.log(data);
                if (!data.active) {
                   console.log("Session expired! Reloading...");
                    location.reload();
                }
            })
            .catch(error => console.error("Session check failed", error));
    }, 60000); // Check every 60 seconds
</script>
@endsection

