@extends('layouts.frontend.user_master')
@section('title', 'User Dashbaord')

@section('css')
    <style>
        .all-transaction table td {
            text-align: unset !important;
        }

        .all-transaction table tr th {
            text-align: unset !important;
        }

        td.text-white {
            word-break: break-word !important;
            min-width: 360px !important;
            white-space: normal !important;
        }

        .all-transaction table td span {
            font-size: 16px;
        }

        .calendar_img {
            background-image: url("{{ asset('assets/icons/calendar.png') }}");
            background-size: 25px;
            background-repeat: no-repeat;
            background-position: 95% 50%;
        }
    </style>
@endsection

@section('style')
@endsection

@section('content')
    <!-- inner-hero-section start -->
    <div class="inner-hero-section style--five">
    </div>
    <!-- inner-hero-section end -->

    <!-- user section start -->
    <div class="mt-minus-150 pb-120">
        <div class="container">
            <div class="row">

                @include('application.user.side_nav')

                <div class="col-lg-8 mt-lg-0 mt-4">
                    {{-- <div style="display: none;" class="transaction-balance-wrapper">
                        <div class="left">
                            <div class="transaction-balance">
                                <h4 class="balance" id="grandTotal">$2956.00</h4>
                                <span>Available Balance</span>
                            </div>
                        </div>
                        <div class="right">
                            <a href="#0" class="transaction-action-btn">
                                <img src="{{ asset('frontend/assets/images/icon/transaction/1.png') }}" alt="image">
                                <span>Deposit</span>
                            </a>
                            <a href="#0" class="transaction-action-btn ml-4">
                                <img src="{{ asset('frontend/assets/images/icon/transaction/2.png') }}" alt="image">
                                <span>Withdraw</span>
                            </a>
                        </div>
                    </div> --}}
                    <!-- transaction-balance-wrapper end -->
                    <div class="all-transaction">
                        <div class="all-transaction__header">
                            <h3 class="title" style="width: max-content;">All Transactions</h3>
                            <div class="date-range">
                                <input type="text" data-range="true" id="date-range" data-multiple-dates-separator=" - "
                                    data-language="en" autocomplete="off" class="datepicker-here calendar_img form-control"
                                    data-position='top left' placeholder="min - max date" />
                                {{-- <i class="las la-calendar-alt"></i> --}}
                            </div>
                            <a href="{{ route('frontend.user.transactions') }}" type="submit"
                                class="cmn-btn style--three btn--sm submitBtn text-white" style="">
                                Reset
                            </a>
                        </div>
                        <div style="overflow: auto" class="table-responsive-xl">
                            <table id="orders-table">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Description</th>
                                        <th>Tickets</th>
                                        <th>Draw Date</th>
                                        <th>Pay. method</th>
                                        <th>Amount</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                @php
                                    $grandTotal = 0;
                                @endphp
                                <tbody id="orders-data">
                                    @include('application.user.partials.transactions', [
                                        'transactions' => $transactions,
                                        'grandTotal' => $grandTotal,
                                    ])
                                </tbody>
                            </table>
                        </div>
                        <div class="load-more"><button id="load-more" type="button"
                                data-current-page="{{ $transactions->currentPage() }}"
                                data-last-page="{{ $transactions->lastPage() }}">Show More Data <i
                                    class="las la-angle-down ml-2"></i></button></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- user section end -->
@endsection

@section('script')
    <script type="text/javascript">
        $(document).ready(function() {
            getTransactionsBalance();

            $('#date-range').datepicker({
                onSelect: function(formattedDate, date, inst) {
                    if (date.length == 2) {
                        fetchTransactionsData(1, 'date');
                    }
                }
            });

            $('#load-more').click(function() {
                var currentPage = $(this).data('current-page');
                var lastPage = $(this).data('last-page');

                if (currentPage < lastPage) {
                    var nextPage = currentPage + 1;
                    fetchTransactionsData(nextPage);

                } else {
                    $('#load-more').remove();
                }
            });

            function getTransactionsBalance() {
                setTimeout(() => {
                    var totalSum = 0;
                    $('.transactionsTotal').each(function() {
                        totalSum += parseFloat($(this).val());
                    });

                    $("#grandTotal").html('$' + totalSum);

                }, 50);
            }

            function fetchTransactionsData(nextPage, requestType = null) {

                var dateRange = $('#date-range').val();
                if (requestType) {
                    $('#orders-data').empty();
                }
                $.ajax({
                    url: "{{ route('frontend.user.transactions') }}",
                    type: 'GET',
                    dataType: "JSON",
                    data: {
                        page: nextPage,
                        date_range: dateRange
                    },
                    beforeSend: function() {
                        $('#load-more').attr('disabled', true).text('Loading...');
                    },
                    success: function(response) {
                        getTransactionsBalance();
                        console.log(response.html);
                        $('#orders-data').append(response.html);

                        $('#load-more').attr('disabled', false).text('Show More Data');
                        $('#load-more').data('current-page', response.current_page);
                        if (response.current_page >= response.last_page) {
                            $('#load-more').remove();
                        }
                    }
                });
            }
        });
    </script>
@endsection
