<div class="col-lg-4">
    <form action="{{ route('frontend.user.update-info') }}" enctype="multipart/form-data" method="post">
        @csrf
        <div class="user-card">
            <div class="avatar-upload">
                <div class="obj-el"><img src="{{ asset('frontend/assets/images/elements/team-obj.png') }}" alt="image">
                </div>

                <div class="avatar-edit">
                    <input type="hidden" name="id" value="{{ $user->id }}" />
                    <input type='file' id="imageUpload" name="additional[profile_pic]" accept=".png, .jpg, .jpeg" />
                    <label for="imageUpload"></label>
                </div>

                <div class="avatar-update-btn user-info-card__header" id="avatarUpdateBtn">
                    <button type="submit" class="update-btn">
                        <i class="fa fa-check" aria-hidden="true"></i>
                    </button>
                </div>

                @if (!empty($user->additional_info->profile_pic) && Storage::exists($user?->additional_info?->profile_pic))
                    <div class="avatar-preview">
                        <div id="imagePreview"
                            style="background-image: url({{ asset(Storage::url($user->additional_info->profile_pic)) }});">
                        </div>
                    </div>
                @else
                    <div class="avatar-preview">
                        <div id="imagePreview"
                            style="background-image: url({{ asset('frontend/assets/images/user/pp.png') }});">
                        </div>
                    </div>
                @endif
            </div>
            <h3 class="user-card__name">{{ $user->name }}</h3>
            <span class="user-card__id text-white">ID : {{ strtoupper(substr($user->name, 0, 2) . $user->id) }}</span>
        </div><!-- user-card end -->
    </form>

    <div class="user-action-card">
        <ul class="user-action-list">
            <li class="{{ Route::currentRouteName() !== 'frontend.user.tickets' ?: 'active' }}">
                <a href="{{ route('frontend.user.tickets') }}">My Tickets</a>
            </li>

            <li class="{{ Route::currentRouteName() !== 'frontend.user.dashboard' ?: 'active' }}">
                <a href="{{ route('frontend.user.dashboard') }}">Personal Information</a>
            </li>

            <li class="{{ Route::currentRouteName() !== 'frontend.user.transactions' ?: 'active' }}">
                <a href="{{ route('frontend.user.transactions') }}">Transactions</a>
            </li>

            {{-- <li class="{{ Route::currentRouteName() !== 'frontend.user.referral-program'?:'active' }}">
                <a href="{{route('frontend.user.referral-program')}}">Referral Program</a></li> --}}

            <li class="{{ Route::currentRouteName() !== 'frontend.user.favorite-lottery' ?: 'active' }}">
                <a href="{{ route('frontend.user.favorite-lottery') }}">Favorite Lotteries</a>
            </li>

            <li><a href="{{ route('contact-us') }}">Help Center</a></li>

            <li><a href="{{ route('frontend.user.logout') }}">Log Out</a></li>
        </ul>
    </div><!-- user-action-card end -->
</div>
