@php
    $grandTotal = 0;
@endphp

@foreach ($transactions as $transaction)
    <tr>
        <td>
            <span class="date">
                <span>{{ \Carbon\Carbon::parse($transaction->date)->format('d-m-Y H:i:s') }}</span>
            </span>
        </td>
        <td class="text-white">
            {{ $transaction->contest_title . ' - ' . ' Tickets : ' . $transaction->total_tickets }}
        </td>
        <td class="text-white">
            @php
                $tickets = \App\Models\OrdersTickets::where('order_id', $transaction->order_id)
                    ->where('contest_id', $transaction->contest_id)
                    ->pluck('ticket_id')
                    ->toArray();
                if ($tickets) {
                    foreach ($tickets as $key => $ticket) {
                        echo $ticket . ($key + 1 < count($tickets) ? ', ' : '');
                    }
                } else {
                    echo '---';
                }
            @endphp
        </td>
        <td class="text-white">
            {{ !empty($transaction->draw_date) ? date('d-m-Y', strtotime($transaction->draw_date)) : '-' }}</td>
        <td>
            {{-- @php
                $paymentResponse = json_decode($transaction->payment_response);
                print_r($paymentResponse->payment_response);
            @endphp --}}
            <span>Card</span>
        </td>
        <td>
            <span class="amount {{ $transaction->amount < 0 ? 'minus-amount' : 'plus-amount' }}">
                {{ $transaction->amount < 0 ? '-' : '' }}
                {{ config('app.currency_symbol') }}{{ number_format(abs($transaction->amount), 2) }} (EUR)
                @php
                    $grandTotal += $transaction->amount;
                @endphp
            </span>
        </td>
        <td>
            <span style="color: {{ $transaction->payment_status == 'paid' ? '#22b868' : 'red' }}"
                class="status-{{ $transaction->payment_status == 'paid' ? 'success' : 'pending' }}">
                {{ ucwords($transaction->payment_status) }}
            </span>
        </td>
    </tr>
@endforeach
<input type="hidden" class="transactionsTotal" value="{{ $grandTotal }}">
