@extends('layouts.frontend.user_master')
@section('title', 'User Dashbaord')

@section('css')
@endsection

@section('style')
@endsection

@section('content')
    <!-- inner-hero-section start -->
    <div class="inner-hero-section style--five">
    </div>
    <!-- inner-hero-section end -->

    <!-- user section start -->
    <div class="mt-minus-150 pb-120">
        <div class="container">
            <div class="row">

                @include('application.user.side_nav')

                <div class="col-lg-8 mt-lg-0 mt-4">

                    @include('application.user.upcoming_draw')

                    <div class="row mt-30 mb-none-30">
                        @if($favorites->count())
                            @php
                                $favContests = Auth::user()->favContests ?? [];
                                $favContestsIds = [];
                                foreach ($favContests as $key => $favContest) {
                                    $favContestsIds[] = $favContest->contest_id;
                                }
                            @endphp

                            @foreach ($favorites as $key => $favorite)
                                @php
                                    $contest = $favorite->contest;
                                @endphp
                                @if($contest)
                                    <div class="col-xl-6 col-lg-12 col-md-6 mb-30">
                                        <div class="contest-card__fav">
                                            <a href="{{Auth::check()?'javascript:0;':route('frontend.login')}}" id="favTag{{$contest?->id}}" data-contest_id="{{$contest?->id}}" class="action-icon">
                                                @if(in_array($contest?->id, $favContestsIds))
                                                    <i class="fa fa-heart"></i>
                                                @else
                                                    <i class="far fa-heart"></i>
                                                @endif
                                            </a>
                                        </div>
                                        <div class="contest-card">
                                            <a href="{{route('contest-details', ['id' => $contest?->id, 'slug' => $contest?->slug])}}" class="item-link"></a>
                                            <div class="contest-card__thumb">
                                                @if(!empty($contest->images[0]?->path) && Storage::exists($contest->images[0]?->path))
                                                    <img src="{{asset(Storage::url($contest?->images[0]?->path))}}" alt="{{$contest?->title.' Banner Image'}}">
                                                @else
                                                    <img src="{{asset('frontend/assets/images/contest/1.png')}}" alt="image">
                                                @endif
                                                <div class="contest-num">
                                                    <span>contest no:</span>
                                                    <h4 class="number">{{$contest?->contest_no}}</h4>
                                                </div>
                                            </div>
                                            <div class="contest-card__content">
                                                <div class="left">
                                                    <h5 class="contest-card__name">
                                                        {{$contest?->title}}
                                                    </h5>
                                                </div>
                                                <div class="right">
                                                    <span class="contest-card__price">{{config('app.currency_symbol')}}{{$contest?->price}}</span>
                                                    <p>ticket price</p>
                                                </div>
                                            </div>
                                            <div class="contest-card__footer">
                                                <ul class="contest-card__meta">
                                                    <li>
                                                        <i class="las la-clock"></i>
                                                        <span>
                                                            @if(!empty($contest?->contest_end))
                                                                {{\Carbon\Carbon::now()->diffInDays($contest?->contest_end, false)}}d
                                                            @else
                                                                0d
                                                            @endif
                                                        </span>
                                                    </li>
                                                    <li>
                                                        <i class="las la-ticket-alt"></i>
                                                        <span>{{$contest?->qty}}</span>
                                                        <p>Remaining</p>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        @else
                            <div class="col-md-12 mt-5">
                                <h2 class="text-center mt-5">No Favorites Found!</h2>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- user section end -->
@endsection

@section('script')
@endsection
