@extends('layouts.frontend.user_master')
@section('title', 'User Dashbaord')

@section('css')
    <style>
        .user-info-card__list li .caption {
            margin-right: 15px !important;
            width: 30%;
        }

        .user-info-card__list li .value {
            width: 65%;
            padding-left: 25px;
        }

        .user-info-card__list .iti {
            width: 100% !important;
        }

        .iti__country-container {
            margin-top: 1px;
        }
    </style>
@endsection

@section('script')

    <script>
        $(document).ready(function() {
            $('.submitBtn').hide();
            $('.ppSubmitBtn').hide();
            $('.input_fields').hide();
            setTimeout(() => {
                $('.nice-select').remove();
            }, 200);
            $('#imageUpload').on('change', function() {
                $('.ppSubmitBtn').show();
            });
            $('.edit_user_info').on('click', function() {
                var $ul = $(this).closest('.user-info-card').find('ul');
                $ul.find('input').prop('disabled', false);
                $(this).closest('.user-info-card').find('.submitBtn').show();
                $(this).closest('.user-info-card').find('.input_fields').show();
                $(this).closest('.user-info-card').find('.span_fields').hide();
            });
        });
    </script>
@endsection

@section('content')
    <!-- inner-hero-section start -->
    <div class="inner-hero-section style--five">
    </div>
    <!-- inner-hero-section end -->

    <!-- user section start -->
    <div class="mt-minus-150 pb-120">
        <div class="container">
            <div class="row">
                @php
                    $languages = app('bmf')->getLanguages();
                    $timezones = app('bmf')->getTimeZones();
                @endphp

                @include('application.user.side_nav')

                <div class="col-lg-8 mt-lg-0 mt-5">
                    <form action="{{ route('frontend.user.update-info') }}" enctype="multipart/form-data" method="post">
                        <input type="hidden" name="id" value="{{ $user->id }}" />
                        @csrf
                        <div class="user-info-card">
                            <div class="user-info-card__header">
                                <h3 class="user-info-card__title">Personal Information</h3>

                                <div>
                                    <button type="submit" class="cmn-btn style--three btn--sm submitBtn">Submit</button>
                                    <button type="button" class="edit_user_info"><i class="far fa-edit"></i> Edit</button>
                                </div>
                            </div>
                            <ul class="user-info-card__list">
                                <li>
                                    <span class="caption">First Name</span>
                                    <span class="value span_fields">{{ $user?->first_name }}</span>
                                    <input type="text" class="value input_fields" name="user[first_name]"
                                        value="{{ $user?->first_name }}" disabled>
                                </li>
                                <li>
                                    <span class="caption">Last Name</span>
                                    <span class="value span_fields">{{ $user?->last_name }}</span>
                                    <input type="text" class="value input_fields" name="user[last_name]"
                                        value="{{ $user?->last_name }}" disabled>
                                </li>
                                <li>
                                    <span class="caption">Date of Birth</span>
                                    <span class="value span_fields">{{ $user?->additional_info?->dob }}</span>
                                    <input type="date" class="value input_fields" name="additional[dob]"
                                        value="{{ $user?->additional_info?->dob }}" disabled>
                                    <!-- <span class="value">15-03-1974</span> -->
                                </li>
                                <li>
                                    <span class="caption">Gender</span>
                                    <span
                                        class="value span_fields">{{ ucwords($user?->additional_info?->gender ?? '') }}</span>
                                    <select class="input_fields value" name="additional[gender]">
                                        <option>Select Gender</option>
                                        <option {{ $user?->additional_info?->gender == 'male' ? 'selected' : '' }}
                                            value="male">Male</option>
                                        <option {{ $user?->additional_info?->gender == 'female' ? 'selected' : '' }}
                                            value="female">Female
                                        </option>
                                        <option {{ $user?->additional_info?->gender == 'other' ? 'selected' : '' }}
                                            value="other">Other
                                        </option>
                                    </select>
                                    <!--  -->
                                </li>
                                <li>
                                    <span class="caption">Flat / Door Number</span>
                                    <span class="value span_fields">{{ $user?->additional_info?->flat_no }}</span>
                                    <input type="text" class="value input_fields" name="additional[flat_no]"
                                        value="{{ $user?->additional_info?->flat_no }}" disabled>
                                </li>
                                <li>
                                    <span class="caption">Landmark</span>
                                    <span class="value span_fields">{{ $user?->additional_info?->landmark }}</span>
                                    <input type="text" class="value input_fields" name="additional[landmark]"
                                        value="{{ $user?->additional_info?->landmark }}" disabled>
                                </li>
                                <li>
                                    <span class="caption">Street</span>
                                    <span class="value span_fields">{{ $user?->additional_info?->address }}</span>
                                    <input type="text" class="value input_fields" name="additional[address]"
                                        value="{{ $user?->additional_info?->address }}" disabled>
                                </li>
                                <li>
                                    <span class="caption">City</span>
                                    <span class="value span_fields">{{ $user?->additional_info?->city }}</span>
                                    <input type="text" class="value input_fields" name="additional[city]"
                                        value="{{ $user?->additional_info?->city }}" disabled>
                                </li>
                                <li>
                                    <span class="caption">State / Province</span>
                                    <span class="value span_fields">{{ $user?->additional_info?->state }}</span>
                                    <input type="text" class="value input_fields" name="additional[state]"
                                        value="{{ $user?->additional_info?->state }}" disabled>
                                </li>
                                <li>
                                    <span class="caption">Postal Code</span>
                                    <span class="value span_fields">{{ $user?->additional_info?->postal_code }}</span>
                                    <input type="text" class="value input_fields" name="additional[postal_code]"
                                        value="{{ $user?->additional_info?->postal_code }}" disabled>
                                </li>
                                <li>
                                    <span class="caption">Country</span>
                                    <span class="value span_fields">{{ $user?->additional_info?->country }}</span>
                                    <select class="input_fields value" name="additional[country]">
                                        <option>Select Country</option>
                                        @foreach (\App\Models\Country::get() as $country)
                                            <option value="{{ $country->nicename }}"
                                                {{ $user?->additional_info?->country == $country->nicename ? 'selected' : '' }}>
                                                {{ $country->nicename }}</option>
                                        @endforeach
                                    </select>
                                </li>
                            </ul>
                        </div><!-- user-info-card end -->

                        <div class="user-info-card">
                            <div class="user-info-card__header">
                                <h3 class="user-info-card__title">Email Addresses</h3>

                                <div>
                                    <button type="submit" class="cmn-btn style--three btn--sm submitBtn">Submit</button>
                                    <button type="button" class="edit_user_info"><i class="far fa-edit"></i>
                                        Edit</button>
                                </div>
                            </div>
                            <ul class="user-info-card__list">
                                <li>
                                    <span class="caption">Email</span>
                                    <span class="value span_fields">{{ $user?->email }}</span>
                                    <input type="text" class="value input_fields" name="language"
                                        value="{{ $user?->email }}" disabled>
                                </li>
                            </ul>
                        </div><!-- user-info-card end -->

                        <div class="user-info-card">
                            <div class="user-info-card__header">
                                <h3 class="user-info-card__title">Phone</h3>

                                <div>
                                    <button type="submit" class="cmn-btn style--three btn--sm submitBtn">Submit</button>
                                    <button type="button" class="edit_user_info"><i class="far fa-edit"></i>
                                        Edit</button>
                                </div>
                            </div>
                            <ul class="user-info-card__list">
                                <li>
                                    <span class="caption">Mobile</span>

                                    <div class="mobile_input" style="width: 65%;">
                                        <span class="value span_fields data_view"
                                            style="padding-left: 55px;">{{ $user?->additional_info?->phone }}</span>
                                        <input type="text" class="value input_fields w-100" id="full_number"
                                            name="additional[phone]" value="{{ $user?->additional_info?->phone }}"
                                            disabled>
                                    </div>

                                    <input type="hidden" name="country_code" id="country_code">
                                    {{-- <input type="hidden" name="additional[phone]" id="phone"> --}}
                                    <input type="hidden" name="additional[iso2]" id="country_iso">
                                    <input type="hidden" name="mobile" id="mobile">
                                </li>
                            </ul>
                        </div><!-- user-info-card end -->

                        <div class="user-info-card">
                            <div class="user-info-card__header">
                                <h3 class="user-info-card__title">Account Settings</h3>

                                <div>
                                    <button type="submit" class="cmn-btn style--three btn--sm submitBtn">Submit</button>
                                    <button type="button" class="edit_user_info"><i class="far fa-edit"></i>
                                        Edit</button>
                                </div>
                            </div>
                            <ul class="user-info-card__list">
                                <li>
                                    <span class="caption">Language</span>
                                    <span
                                        class="value span_fields">{{ $languages[$user?->additional_info?->language] ?? '' }}</span>
                                    <select class="input_fields value" name="additional[language]">
                                        <option>Select Language</option>
                                        @foreach ($languages as $key => $language)
                                            <option value={{ $key }}
                                                {{ $user?->additional_info?->language == $key ? 'selected' : '' }}>
                                                {{ $language }}</option>
                                        @endforeach
                                    </select>
                                </li>
                                <li>
                                    <span class="caption">Time Zone</span>
                                    <span
                                        class="value span_fields">{{ $timezones[$user?->additional_info?->timezone] ?? '' }}</span>
                                    <select class="input_fields value" name="additional[timezone]">
                                        <option>Select Timezone</option>
                                        @foreach ($timezones as $key => $timezone)
                                            <option value={{ $key }}
                                                {{ $user?->additional_info?->timezone == $key ? 'selected' : '' }}>
                                                {{ $timezone }}</option>
                                        @endforeach
                                    </select>
                                    <!--  -->
                                </li>
                                <li>
                                    <span class="caption">Status</span>
                                    <span
                                        class="value status-{{ $user->status == 1 ? 'active' : 'inactive' }}">{{ $user->status == 1 ? 'Active' : 'In active' }}</span>
                                    <!-- <input type="text" class="value input_fields" name="status" value="{{ $user->name }}" disabled> -->
                                </li>
                            </ul>
                        </div><!-- user-info-card end -->

                        <div class="user-info-card">
                            <div class="user-info-card__header">
                                <h3 class="user-info-card__title">Security</h3>

                                <div>
                                    <button type="submit" class="cmn-btn style--three btn--sm submitBtn">Submit</button>
                                    <button type="button" class="edit_user_info"><i class="far fa-edit"></i>
                                        Edit</button>
                                </div>
                            </div>
                            <ul class="user-info-card__list">
                                <li>
                                    <span class="caption">Password</span>
                                    <span class="value span_fields user-password">***************</span>
                                    <input type="text" class="value input_fields" name="user[password]" disabled>
                                </li>
                            </ul>
                        </div><!-- user-info-card end -->
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- user section end -->
@endsection

@section('script')
@endsection
