@extends('layouts.frontend.master')
@section('title', 'FAQs')

@section('css')
@endsection

@section('style')
@endsection

@section('content')
    <!-- inner-hero-section start -->
    <div class="inner-hero-section style--four">
        <div class="bg-shape"><img src="{{ asset('frontend/assets/images/elements/inner-hero-shape-2.png') }}" alt="image">
        </div>
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <ul class="page-list">
                        <li><a href="index.php">Home</a></li>
                        <li class="active">Faq</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- inner-hero-section end -->

    <!-- faq section start -->
    <section class="pb-120 mt-minus-150">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="faq-top-wrapper pt-120">
                        <div class="section-header text-center">
                            <span class="section-sub-title">You Have Questions</span>
                            <h2 class="section-title">WE HAVE ANSWERS</h2>
                            <p>Do not hesitate to send us an email if you can't find what you're looking for.</p>
                        </div>
                        <ul style="display: none;" class="nav nav-tabs cmn-tabs justify-content-center" id="myTab"
                            role="tablist">
                            @foreach ($faqCategories as $kc => $category)
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link {{ $kc == 0 ? 'active' : '' }}" id="result-tab" data-toggle="tab"
                                        href="{{ $category->slug }}" role="tab" aria-controls="result"
                                        aria-selected="false">{{ $category->title }}</a>
                                </li>
                            @endforeach
                        </ul>
                    </div><!-- faq-top-wrapper end -->
                </div>
            </div>
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="faq-body-wrapper">
                        <div class="tab-content" id="myTabContent">
                            @foreach ($faqCategories as $k => $category)
                                <div class="tab-pane fade {{ $k == 0 ? 'show active' : '' }}" id="{{ $category->slug }}"
                                    role="tabpanel" aria-labelledby="ticket-tab">
                                    <div class="accordion cmn-accordion" id="{{ $category->slug }}-{{ $k }}">
                                        @if ($category->faqs)
                                            @foreach ($category->faqs as $fk => $faq)
                                                <div class="card">
                                                    <div class="card-header" id="h-1">
                                                        <button class="btn btn-link btn-block text-left collapsed"
                                                            type="button" data-toggle="collapse"
                                                            data-target="#collapse{{ $fk }}" aria-expanded="true"
                                                            aria-controls="collapse{{ $fk }}">
                                                            {!! $faq->question !!}
                                                        </button>
                                                    </div>
                                                    <div id="collapse{{ $fk }}" class="collapse"
                                                        aria-labelledby="h-1"
                                                        data-parent="#{{ $category->slug }}-{{ $k }}">
                                                        <div class="card-body">
                                                            {!! $faq->answer !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        @else
                                            <div class="card">
                                                <div class="card-header" id="h-1">
                                                    <div id="collapse1" class="collapse" aria-labelledby="h-1"
                                                        data-parent="#{{ $category->slug }}-{{ $k }}">
                                                        <div class="card-body">
                                                            No FAQs Found
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div><!-- tab-content end -->
                    </div><!-- faq-body-wrapper end -->
                </div>
            </div>
        </div>
    </section>
    <!-- faq section end -->
@endsection

@section('script')
    <script>
        $(document).ready(function() {
            $('.nav-link').click(function(event) {
                event.preventDefault(); // Prevent default anchor tag behavior
                $('.nav-link').removeClass('active');
                $(this).addClass('active');

                // Update tab content based on clicked tab
                const clickedTabSlug = $(this).attr('href');
                $('.tab-content').find('.tab-pane.active').removeClass('show active');
                $('#' + clickedTabSlug).addClass('show active');
            });
        });
    </script>
@endsection
