<section class="pb-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="section-header text-center">
                    <span class="section-sub-title">{{$support->sub_title ?? 'Get in touch with our friendly support'}}</span>
                    <h2 class="section-title">{{$support->title ?? 'Customer Support'}}</h2>
                    <div class="description_box text-white">
                        {!! $support->description ?? '<p>Have a question or need help? Contact our friendly support team.</p>' !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="row mb-none-30">
            <div class="col-lg-6 mb-30 wow zoomIn" data-wow-duration="0.5s" data-wow-delay="0.3s">
                <div class="support-card">
                    <div class="support-card__thumb">
                        @if(!empty($supportTeam->image) && Storage::exists($supportTeam->image))
                            <img src="{{asset(Storage::url($supportTeam->image))}}" alt="image" />
                        @else
                            <img src="{{asset('frontend/assets/images/icon/support/1.png')}}" alt="image" />
                        @endif
                    </div>
                    <div class="support-card__content">
                        <h3 class="support-card__title">{{$supportTeam->title ?? 'Talk to our support team'}}</h3>
                        <p>
                            {{$supportTeam->sub_title ?? 'Got a question about Lotteries? Get in touch with our friendly staff.'}}
                        </p>
                        @php
                            $supportTeamContact = !empty($supportTeam->value)?json_decode($supportTeam->value):null;
                        @endphp
                        <div class="btn-grp justify-content-xl-start mt-3">
                            <a href="tel:{{$supportTeamContact->mobile ?? '6564545'}}" class="btn-border btn-sm text-capitalize">Call us <i
                                    class="fas fa-phone-alt"></i></a>
                            <a href="mailto:{{$supportTeamContact->email ?? 'dhdj@gmail.com'}}" class="cmn-btn btn-sm text-capitalize">Email us <i
                                    class="far fa-envelope"></i></a>
                        </div>
                    </div>
                </div>
                <!-- support-card end -->
            </div>
            @php
                $supportFaqsData = !empty($supportFaqs->value)?json_decode($supportFaqs->value):null;
            @endphp
            <div class="col-lg-6 mb-30 wow zoomIn" data-wow-duration="0.5s" data-wow-delay="0.5s">
                <div class="support-card">
                    <div class="support-card__thumb">
                        @if(!empty($supportFaqs->image) && Storage::exists($supportFaqs->image))
                            <img src="{{asset(Storage::url($supportFaqs->image))}}" alt="image" />
                        @else
                            <img src="{{asset('frontend/assets/images/icon/support/2.png')}}" alt="image" />
                        @endif
                    </div>
                    <div class="support-card__content">
                        <h3 class="support-card__title">{{$supportFaqs->title ?? 'Our Guide to BMF Competitions'}}</h3>
                        <p>{{$supportFaqs->sub_title ?? 'Check out our FAQs to see if we can help you out.'}}</p>
                        <div class="btn-grp justify-content-xl-start mt-3">
                            <a href="{{$supportFaqsData->link ?? 'javascript:0;'}}" class="btn-border btn-sm text-capitalize">{{$supportFaqsData->title ?? 'FAQs & Help'}}</a>
                        </div>
                    </div>
                </div>
                <!-- support-card end -->
            </div>
        </div>
    </div>
</section>
