 @php
     $howToPlaySteps = $howToPlay->moreRelatedData ?? null;
 @endphp
 <section class="position-relative pt-120 pb-120 overflow-hidden">
     <div class="play-elements wow bounceIn" data-wow-duration="0.5s" data-wow-delay="0.7s">
         <img src="{{ asset('frontend/assets/images/elements/play-el.png') }}" alt="image" />
     </div>
     <div class="container">
         <div class="row">
             <div class="col-lg-6 text-sm-left text-center wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">
                 <div class="section-header">
                     <span class="section-sub-title">{{ $howToPlay->title ?? 'Need to know about' }}</span>
                     <h2 class="section-title">{{ $howToPlay->sub_title ?? 'How To Play' }}</h2>
                     <div>{!! $howToPlay->description ?? '<p>Follow these 3 easy steps!</p>' !!}</div>
                 </div>
             </div>
         </div>
         <div class="row mb-none-30 justify-content-xl-start justify-content-center">
             <div class="col-md-9">
                 <div class="row justify-content-center">
                     @if ($howToPlaySteps)
                         @foreach ($howToPlaySteps as $key => $step)
                             <div class="col-xl-4 col-lg-4 col-sm-6 mb-30">
                                 <div class="play-card bg_img"
                                     data-background="{{ asset('frontend/assets/images/elements/card-bg-1.jpg') }}">
                                     <div class="play-card__icon">
                                         @if (!empty($step->image) && Storage::exists($step->image))
                                             <img src="{{ asset(Storage::url($step->image)) }}" alt="image-icon" />
                                         @else
                                             <img src="{{ asset('frontend/assets/images/icon/play/1.png') }}"
                                                 alt="image-icon" />
                                         @endif
                                         <span class="play-card__number">0{{ $key + 1 }}</span>
                                     </div>
                                     <div class="play-card__content">
                                         <h3 class="play-card__title">{{ $step->title ?? 'Choose' }}</h3>
                                         <p>{{ $step->sub_title ?? 'Register to BMF Competitions & Choose your contest' }}
                                         </p>
                                     </div>
                                 </div>
                                 <!-- play-card end -->
                             </div>
                         @endforeach
                     @endif
                 </div>
             </div>
         </div>
     </div>
 </section>
