@if($contests->count())
    @php
        $favContests = Auth::user()->favContests ?? [];
        $favContestsIds = [];
        foreach ($favContests as $key => $favContest) {
            $favContestsIds[] = $favContest->contest_id;
        }
    @endphp
    <section id="buyTickets" class="position-relative pt-120 pb-120">
        <div class="bg-el">
            <img src="{{asset('frontend/assets/images/elements/contest-bg.png')}}" alt="image" />
        </div>
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8 wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">
                    <div class="section-header text-center">
                        <span class="section-sub-title">{{$context->title ?? 'Try your chance at winning'}}</span>
                        <h2 class="section-title">{{$context->sub_title ?? 'Current Contest'}}</h2>
                        <div class="description_box text-white">
                            {!! $context->description ?? '<p>Participants buy tickets and lots are drawn to determine the winners.</p>' !!}
                        </div>
                    </div>
                </div>
            </div>
            <!-- row end -->
            <div class="row wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">
                <div class="col-lg-12">
                    <!-- <ul class="nav nav-tabs justify-content-center mb-30 border-0" id="buyTickets" role="tablist">
                        <li class="nav-item" role="presentation">
                            <a class="cmn-btn d-flex align-items-center active" id="car-tab" data-toggle="tab" href="#car"
                                role="tab" aria-controls="car" aria-selected="true"><span class="mr-3"><img
                                        src="assets/images/icon/btn/car.png" alt="icon" /></span>
                                Dream Car</a>
                        </li>
                        <li class="nav-item" role="presentation">
                            <a class="cmn-btn style--two d-flex align-items-center" id="lifestyle-tab" data-toggle="tab"
                                href="#lifestyle" role="tab" aria-controls="lifestyle" aria-selected="false"><span
                                    class="mr-3"><img src="assets/images/icon/btn/box.png" alt="icon" /></span>All
                                lifestyle</a>
                        </li>
                    </ul> -->
                    <div class="tab-content" id="contestTabContent">

                        <div class="tab-pane fade show active" id="car" role="tabpanel" aria-labelledby="car-tab">
                            <div class="row mb-none-30">
                                @foreach ($contests as $key => $contest)
                                    @include('application.contest.contast-card', ['contest' => $contest])
                                @endforeach
                            </div>
                        </div>
                    </div>
                    <!-- table content end -->
                </div>
            </div>
            <!-- row end-->

            @if(count($contests) >= 6)
                <div class="row mt-30">
                    <div class="col-lg-12">
                        <div class="btn-grp">
                            <a href="{{route('contest-listing')}}" class="btn-border">browse more</a>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </section>
@endif
