@extends('layouts.frontend.master')
@section('title', ($contest->contest_number ?? $contest->contest_no) . ' - ' . $contest->title)

@section('css')
@endsection

@section('style')
@endsection

@section('content')
    <!-- inner-hero-section start -->
    <div class="inner-hero-section">
        <div class="bg-shape">
            <img src="{{ asset('frontend/assets/images/elements/inner-hero-shape.png') }}" alt="image" />
        </div>
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <ul class="page-list">
                        <li><a href="{{ route('home') }}">Home</a></li>
                        <li><a href="{{ route('contest-listing') }}">Contest List</a></li>
                        <li class="active">Contest No: {{ $contest->contest_number ?? ($contest->contest_no ?? '') }}</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- inner-hero-section end -->

    <!-- contest-details-section start -->
    <section class="pb-120 mt-minus-300">
        <div class="container">
            <div class="row justify-content-center">
                {{-- {{dd($ticketSoldOut, $contest->qty)}} --}}
                @if ($endDate > now())
                    <div class="col-lg-6">
                        <div class="clock-wrapper">
                            <p class="mb-2">This competition ends in:</p>
                            <div class="clock" data-clock="{{ date('Y/m/d', strtotime($endDate)) }}"></div>
                        </div>
                        <!-- clock-wrapper end -->
                    </div>
                @endif
                <div class="col-lg-12">
                    <div class="contest-cart">
                        <div class="contest-cart__left">
                            <div class="contest-cart__slider-area">
                                <div class="contest-cart__thumb-slider">
                                    @if (count($contest->images))
                                        @foreach ($contest->images as $key => $image)
                                            <div class="single-slide">
                                                @if (!empty($image->path) && Storage::exists($image->path))
                                                    <img src="{{ asset(Storage::url($image->path)) }}"
                                                        alt="{{ $contest->title . ' Banner Image' }}">
                                                @else
                                                    <img src="{{ asset('frontend/assets/images/contest/s1.png') }}"
                                                        alt="image" />
                                                @endif
                                            </div>
                                        @endforeach
                                    @else
                                        <div class="single-slide">
                                            <img src="{{ asset('frontend/assets/images/contest/s1.png') }}"
                                                alt="image" />
                                        </div>
                                    @endif
                                </div>
                                <!-- contest-cart__thumb-slider end -->
                                <div class="contest-cart__nav-slider">
                                    @if (count($contest->images))
                                        @foreach ($contest->images as $key => $image)
                                            <div class="single-slide">
                                                @if (!empty($image->path) && Storage::exists($image->path))
                                                    <img src="{{ asset(Storage::url($image->path)) }}"
                                                        alt="{{ $contest->title . ' Banner Image' }}">
                                                @else
                                                    <img src="{{ asset('frontend/assets/images/contest/s1.png') }}"
                                                        alt="image" />
                                                @endif
                                            </div>
                                        @endforeach
                                    @else
                                        <div class="single-slide">
                                            <img src="{{ asset('frontend/assets/images/contest/s1.png') }}"
                                                alt="image" />
                                        </div>
                                    @endif
                                </div>
                                <!-- contest-cart__nav-slider end -->
                            </div>
                        </div>

                        <!-- contest-cart__left end -->
                        <div class="contest-cart__right">
                            <h4 class="subtitle">Enter now for a chance to win</h4>
                            <h3 class="contest-name">{{ $contest->title }}</h3>
                            <div class="contest-num">Winning Amount: <span>
                                    {{ config('app.currency_symbol') }}{{ $contest->winning_amount ?? ($contest->winning_amount ?? '') }}</span>
                            </div>
                            @if (!empty($contest->price_delivery))
                                <div class="contest-num">Prize Delivery: <span> {{ $contest->price_delivery }}</span>
                                </div>
                            @endif
                            <p>This competition has a maximum of {{ $contest->qty }} entries.</p>
                            <div class="contest-num">Contest no: <span>
                                    {{ $contest->contest_number ?? ($contest->contest_no ?? '') }}</span></div>
                            <h4>Tickets Sold</h4>

                            @php
                                $soldTickets = $contest->orderTickets->count();
                                $remainingContests = $contest->qty - $contest->orderTickets->count();
                            @endphp


                            <div class="ticket-amount">
                                <span class="left">{{ $soldTickets }}</span>
                                <span class="right">{{ $contest->qty }}</span>
                                <div class="progressbar" data-perc="{{ ($soldTickets / $contest->qty) * 100 }}%">
                                    <div class="bar"></div>
                                </div>
                                <p>Only {{ $remainingContests }} remaining!</p>
                            </div>


                            @if ($endDate > now() && $remainingContests != 0)
                                <div class="ticket-price">
                                    <span class="amount">{{ config('app.currency_symbol') }}{{ $contest->price }}</span>
                                    <small>Per ticket</small>
                                </div>

                                <div class="d-flex flex-wrap align-items-center mb-30">
                                    <div class="select-quantity">
                                        <input type="hidden" id="contest_id" value="{{ $contest->id }}" />
                                        <span class="caption">Quantity</span>
                                        <div class="quantity">
                                            <input type="number" id="quantity" min="1"
                                                max="{{ $remainingContests }}" step="1" value="1" readonly />
                                        </div>
                                    </div>
                                    <!-- select-quantity end -->
                                    {{-- @if (Auth::check()) --}}
                                    <div class="mt-sm-0 mt-3">
                                        <a href="javascript:0;" id="buyTicketsButton" class="cmn-btn style--three">buy
                                            tickets</a>
                                    </div>
                                    {{-- @else
                                        <div class="mt-sm-0 mt-3">
                                            <a href="javascript:0;" data-backdrop="static" data-keyboard="false"
                                                data-toggle="modal" data-target="#loginModal"
                                                class="cmn-btn style--three">buy
                                                tickets</a>
                                        </div>
                                    @endif --}}

                                    <div class="text-center text-white" id="cartMessage"></div>
                                </div>
                            @else
                                <div
                                    class="d-flex flex-wrap align-items-center mb-30 text-center flex-column p-5 text-white">
                                    @if (!empty($soldOutImg))
                                        <img src="{{ $soldOutImg }}" />
                                    @else
                                        Contest Expired OR Ticket SoldOut.
                                    @endif
                                </div>
                            @endif
                            {{-- {!! Share::page(route('contest-details', ['id' => $contest->id, 'slug' => $contest->slug]))->facebook()->twitter()->linkedin() !!} --}}
                            <ul class="social-links align-items-center">
                                <li>Share :</li>
                                <li>
                                    <a class="w-inline-block social-share-btn fb"
                                        href="https://www.facebook.com/sharer/sharer.php?u=&t=" title="Share on Facebook"
                                        target="_blank"
                                        onclick="window.open('https://www.facebook.com/sharer/sharer.php?u=' + encodeURIComponent(document.URL) + '&t=' + encodeURIComponent(document.URL)); return false;"><img
                                            src="{{ url('frontend/assets/social-icons/Facebook.svg') }}"></a>
                                </li>
                                <li>
                                    <a class="w-inline-block social-share-btn tw" href="https://twitter.com/intent/tweet?"
                                        target="_blank" title="Tweet"
                                        onclick="window.open('https://twitter.com/intent/tweet?text=%20Check%20up%20this%20awesome%20content' + encodeURIComponent(document.title) + ':%20 ' + encodeURIComponent(document.URL)); return false;"><img
                                            src="{{ url('frontend/assets/social-icons/Twitter.svg') }}" /></a>
                                </li>
                                <!-- <li>
                                                                                                                                                                                                                                                                                                                                                        <a class="w-inline-block social-share-btn lnk" href="http://www.linkedin.com/shareArticle?mini=true&url=&title=&summary=&source=" target="_blank" title="Share on LinkedIn" onclick="window.open('http://www.linkedin.com/shareArticle?mini=true&url=' + encodeURIComponent(document.URL) + '&title=' + encodeURIComponent(document.title)); return false;"><i class="fab fa-linkedin-in"></i></a>
                                                                                                                                                                                                                                                                                                                                                    </li> -->
                                <li>
                                    <a class="w-inline-block social-share-btn tiktok"
                                        href="https://www.tiktok.com/@bmfcompetitions" target="_blank"
                                        title="Share on TikTok"><img
                                            src="{{ url('frontend/assets/social-icons/Tiktok.svg') }}" /></a>
                                </li>
                                <li>
                                    <a class="w-inline-block social-share-btn insta"
                                        href="https://www.instagram.com/bmfcompetitions/" target="_blank"
                                        title="Share on Instagram"><img
                                            src="{{ url('frontend/assets/social-icons/Instagram.svg') }}" /></a>
                                </li>
                            </ul>
                        </div>
                        <!-- contest-cart__right end -->
                    </div>
                    <!-- contest-cart end -->
                </div>
                <!-- col-lg-12 end -->
                <div class="col-lg-10">
                    <div class="contest-description">
                        <ul class="nav nav-tabs justify-content-center mb-30 pb-4 border-0" id="myTab"
                            role="tablist">
                            {{-- <li class="nav-item" role="presentation">
                                <a class="cmn-btn active" id="description-tab" data-toggle="tab" href="#description"
                                    role="tab" aria-controls="description" aria-selected="true"><span
                                        class="mr-3"></span> description</a>
                            </li> --}}
                            <li class="nav-item" role="presentation">
                                <a class="cmn-btn" id="details-tab" data-toggle="tab" href="#details" role="tab"
                                    aria-controls="details" aria-selected="false"><span class="mr-3"></span>competition
                                    details</a>
                            </li>
                        </ul>

                        <div class="tab-content" id="myTabContent">
                            {{-- <div class="tab-pane fade show active" id="description" role="tabpanel"
                                aria-labelledby="description-tab">
                                <div class="content-block">
                                    <h3 class="title">Vehicle Overview</h3>
                                    <p>
                                        {!! $contest->description !!}
                                    </p>
                                </div>
                                <!-- content-block end -->
                                <div class="content-block">
                                    <h3 class="title">Specifications</h3>
                                    <div class="row mb-none-30">
                                        <div class="col-lg-4 col-sm-6 mb-30">
                                            <div class="icon-item">
                                                <div class="icon-item__thumb">
                                                    <img src="{{asset('frontend/assets/images/icon/specification/1.png')}}" alt="image" />
                                                </div>
                                                <div class="icon-item__content">
                                                    <p>0-62mph</p>
                                                    <span>4.0 secs</span>
                                                </div>
                                            </div>
                                            <!-- icon-item end -->
                                        </div>
                                        <div class="col-lg-4 col-sm-6 mb-30">
                                            <div class="icon-item">
                                                <div class="icon-item__thumb">
                                                    <img src="{{asset('frontend/assets/images/icon/specification/2.png')}}" alt="image" />
                                                </div>
                                                <div class="icon-item__content">
                                                    <p>Top Speed</p>
                                                    <span>181 mph</span>
                                                </div>
                                            </div>
                                            <!-- icon-item end -->
                                        </div>
                                        <div class="col-lg-4 col-sm-6 mb-30">
                                            <div class="icon-item">
                                                <div class="icon-item__thumb">
                                                    <img src="{{asset('frontend/assets/images/icon/specification/3.png')}}" alt="image" />
                                                </div>
                                                <div class="icon-item__content">
                                                    <p>Power</p>
                                                    <span>542 bhp</span>
                                                </div>
                                            </div>
                                            <!-- icon-item end -->
                                        </div>
                                        <div class="col-lg-4 col-sm-6 mb-30">
                                            <div class="icon-item">
                                                <div class="icon-item__thumb">
                                                    <img src="{{asset('frontend/assets/images/icon/specification/4.png')}}" alt="image" />
                                                </div>
                                                <div class="icon-item__content">
                                                    <p>Displacement</p>
                                                    <span>4.0ltr</span>
                                                </div>
                                            </div>
                                            <!-- icon-item end -->
                                        </div>
                                        <div class="col-lg-4 col-sm-6 mb-30">
                                            <div class="icon-item">
                                                <div class="icon-item__thumb">
                                                    <img src="{{asset('frontend/assets/images/icon/specification/5.png')}}" alt="image" />
                                                </div>
                                                <div class="icon-item__content">
                                                    <p>bhp</p>
                                                    <span>691</span>
                                                </div>
                                            </div>
                                            <!-- icon-item end -->
                                        </div>
                                        <div class="col-lg-4 col-sm-6 mb-30">
                                            <div class="icon-item">
                                                <div class="icon-item__thumb">
                                                    <img src="{{asset('frontend/assets/images/icon/specification/6.png')}}" alt="image" />
                                                </div>
                                                <div class="icon-item__content">
                                                    <p>Year</p>
                                                    <span>2019</span>
                                                </div>
                                            </div>
                                            <!-- icon-item end -->
                                        </div>
                                    </div>
                                </div>
                                <!-- content-block end -->
                            </div> --}}
                            <div class="tab-pane fade show active" id="details" role="tabpanel"
                                aria-labelledby="details-tab">
                                <div class="content-block">
                                    <h3 class="title">Competition Details</h3>
                                    <p>
                                        {!! $contest->competition_details !!}
                                    </p>
                                </div>
                                <!-- content-block end -->
                            </div>
                        </div>
                        <!-- tab-content end -->
                    </div>
                    <!-- contest-description end -->
                </div>
            </div>
        </div>
    </section>
    <!-- contest-details-section end  -->
@endsection

@section('script')

    @if ($endDate)
        <script>
            function startCountdown(endDate) {
                var countDownDate = new Date(endDate).getTime();

                var x = setInterval(function() {
                    var now = new Date().getTime();
                    var distance = countDownDate - now;
                    var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                    var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                    var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                    var seconds = Math.floor((distance % (1000 * 60)) / 1000);

                    document.getElementById("timer").innerHTML = days + "d " + hours + "h " + minutes + "m " + seconds +
                        "s ";

                    if (distance < 0) {
                        clearInterval(x);
                        document.getElementById("timer").innerHTML = "EXPIRED";
                    }
                }, 1000);
            }


            // Retrieve the end date passed from the controller
            var endDate = '{{ $endDate->toIso8601String() }}';
            // Start the countdown with the retrieved end date
            startCountdown(endDate);


            $(document).ready(function() {
                $("#buyTicketsButton").click(function(e) {
                    $(this).text('Adding To Cart..').attr('disabled', 'disabled');
                    e.preventDefault();
                    let contest_id = $("#contest_id").val();
                    let quantity = $("#quantity").val();
                    let cartDetails = {
                        contest_id: contest_id,
                        quantity: quantity,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    };

                    $.ajax({
                        url: "{{ route('frontend.add.cart') }}",
                        method: 'POST',
                        data: cartDetails,
                        success: function(response) {
                            if (response.status === true) {
                                getCartItemsCount($("#getCartItemsURL").val());
                            }

                            $("#cartMessage").text(response.message);
                            $("#buyTicketsButton").text('buy tickets').removeAttr('disabled');
                            setInterval(() => {
                                $("#cartMessage").text("")
                            }, 3000);
                            return true;
                        },
                        error: function(err) {
                            console.log(err);
                            $("#buyTicketsButton").text('buy tickets').removeAttr('disabled');
                            return false;
                        }
                    });
                });
            });
        </script>
    @endif
@endsection
