<div class="col-xl-4 col-md-6 mb-30 contest_box">
    <div class="contest-card__fav">
        <a href="{{ Auth::check() ? 'javascript:0;' : route('frontend.login') }}" id="favTag{{ $contest->id }}"
            data-contest_id="{{ $contest->id }}" class="action-icon">
            @if (in_array($contest->id, $favContestsIds))
                <i class="fa fa-heart"></i>
            @else
                <i class="far fa-heart"></i>
            @endif
        </a>
    </div>
    <div class="contest-card">
        <a href="{{ route('contest-details', ['id' => $contest->id, 'slug' => $contest->slug]) }}" class="item-link"></a>
        <div class="contest-card__thumb">
            @if (!empty($contest->images[0]->path) && Storage::exists($contest->images[0]->path))
                <img src="{{ asset(Storage::url($contest->images[0]->path)) }}"
                    alt="{{ $contest->title . ' Banner Image' }}">
            @else
                <img src="{{ asset('frontend/assets/images/contest/1.png') }}" alt="image">
            @endif
        </div>
        <div class="contest-card__content">
            <div class="contest-num">
                <span>Contest No:</span>
                <h4 class="number">{{ $contest->contest_no }}</h4>
            </div>
            <div class="left">
                <h5 class="contest-card__name">{{ $contest->title }}</h5>
            </div>
            <div class="right">
                <span class="contest-card__price">{{ config('app.currency_symbol') }}{{ $contest->price }}</span>
                <p>ticket price</p>
            </div>
        </div>
        <div class="contest-card__footer">
            <ul class="contest-card__meta">
                <li>
                    <i class="las la-clock"></i>
                    <span>
                        {{-- {{ $contest->contest_end }} / --}}
                        @if (!empty($contest->contest_end))
                            {{ \Carbon\Carbon::now()->diffInDays($contest->contest_end, false) }}d
                        @else
                            0d
                        @endif
                    </span>
                </li>
                <li>
                    <i class="las la-ticket-alt"></i>
                    <span>{{ $contest->qty - $contest->orderTickets->count() }}</span>
                    <p>Remaining</p>
                </li>
            </ul>
        </div>
    </div><!-- contest-card end -->
</div>
