@extends('layouts.frontend.master')
@section('title', 'Contact Us')

@section('css')
@endsection

@section('style')
<style>
.iti__country-name {
    color: #4823d7;
    line-height: 1.1;
}

.iti__search-input {
    color: #4823d7 !important;
}

.form-group .iti {
    width: 100%;
}

#mobile_no {
    padding-left: 5rem;
}

.iti__selected-country-primary {
    margin-left: -24px;
}
</style>
@endsection

@section('content')
<!-- inner-hero-section start -->
<div class="inner-hero-section style--six">
    <div class="bg-shape"><img src="{{asset('frontend/assets/images/elements/inner-hero-shape-2.png')}}" alt="image">
    </div>
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <ul class="page-list">
                    <li><a href="{{route('home')}}">Home</a></li>
                    <!-- <li><a href="#0">Pages</a></li> -->
                    <li class="active">Contact</li>
                </ul>
            </div>
        </div>
    </div>
</div>
<!-- inner-hero-section end -->

<!-- contact section start -->
<section class="mt-minus-270 pb-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="section-header text-center">
                    <h2 class="section-title">{{ $contact->title ?? 'Contact'}}</h2>
                    <div class="description_box text-white">{!!$contact->description ?? '<p>We’d love to talk about how
                            we can work together.Send us a message below and we’ll respond as soon as possible.</p>'!!}
                    </div>
                </div>
            </div>
            @php( $countries = app('bmf')->getCountriesList())
            <div class="col-lg-12">
                <div class="contact-wrapper">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="contact-form-wrapper">
                                <h3 class="title">Drop us a message</h3>
                                <form class="contact-form" id="contact_form_submit">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>First Name <sup>*</sup></label>
                                                <input type="text" name="name" id="name"
                                                    placeholder="Enter Your First Name">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Last Name <sup>*</sup></label>
                                                <input type="text" name="last_name" id="last_name"
                                                    placeholder="Enter Your Last Name">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Email <sup>*</sup></label>
                                                <input type="email" name="email" id="email"
                                                    placeholder="Enter Your Email">
                                            </div>
                                        </div>

                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Mobile No <sup>*</sup></label><br>
                                                <input type="text" class="w-100" id="full_number"
                                                    placeholder="Enter Your Mobile No">
                                                <input type="hidden" name="country" id="country">
                                                <input type="hidden" name="mobile_no" id="mobile_no">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label>Subject <sup>*</sup></label>
                                        <input type="text" name="subject" id="subject" placeholder="Enter Your Subject">
                                    </div>
                                    <div class="form-group">
                                        <label>Message <sup>*</sup></label>
                                        <textarea name="message" id="message"
                                            placeholder="Write Your Message"></textarea>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="cmn-btn w-100">send message</button>
                                    </div>

                                    <div id="statusMessage"></div>
                                </form><!-- contact-form e nd -->
                            </div><!-- contact-form-wrapper end -->
                        </div>
                        <div class="col-lg-6">
                            <div class="contact-info-wrapper">
                                <div class="d-flex flex-wrap justify-content-between w-100"
                                    style="flex-direction: column">
                                    <div class="contact-info">
                                        <div class="contact-info__icon"><img
                                                src="{{asset('frontend/assets/images/icon/contact/1.png')}}"
                                                alt="image"></div>
                                        <div class="contact-info__content">
                                            <p>Phone Number</p>
                                            <span>{{ $contactPhone->value ?? config('app.contact.phone') }}</span>
                                        </div>
                                    </div><!-- contact-info end -->
                                    <div class="contact-info">
                                        <div class="contact-info__icon"><img
                                                src="{{asset('frontend/assets/images/icon/contact/2.png')}}"
                                                alt="image"></div>
                                        <div class="contact-info__content">
                                            <p>Email</p>
                                            <span>{{ $contactEmail->value ?? config('app.contact.email') }}</span>
                                        </div>
                                    </div><!-- contact-info end -->
                                </div>
                                <div class="contact-thumb">
                                    @if(!empty($contact->image) && Storage::exists($contact->image))
                                    <img src="{{asset(Storage::url($contact->image))}}"
                                        alt="{{$contact->title.' Banner Image'}}">
                                    @else
                                    <img src="{{asset('frontend/assets/images/elements/contact.png')}}" alt="image">
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div style="display: none;" class="row pt-120 mb-none-30">
            <div class="col-lg-3 col-sm-6 mb-30">
                <div class="social-card">
                    <div class="social-card__icon">
                        <i class="fab fa-facebook-f"></i>
                    </div>
                    <div class="social-card__content">
                        <h3>130k</h3>
                        <span>Followers</span>
                    </div>
                </div><!-- social-card end -->
            </div>
            <div class="col-lg-3 col-sm-6 mb-30">
                <div class="social-card">
                    <div class="social-card__icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="social-card__content">
                        <h3>35k</h3>
                        <span>Members</span>
                    </div>
                </div><!-- social-card end -->
            </div>
            <div class="col-lg-3 col-sm-6 mb-30">
                <div class="social-card">
                    <div class="social-card__icon">
                        <i class="fab fa-twitter"></i>
                    </div>
                    <div class="social-card__content">
                        <h3>47k</h3>
                        <span>Followers</span>
                    </div>
                </div><!-- social-card end -->
            </div>
            <div class="col-lg-3 col-sm-6 mb-30">
                <div class="social-card">
                    <div class="social-card__icon">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <div class="social-card__content">
                        <h3>29k</h3>
                        <span>Subscribers</span>
                    </div>
                </div><!-- social-card end -->
            </div>
        </div>
    </div>
</section>
<!-- contact section end -->
<input type="hidden" value="{{route('contact-us.save')}}" id="formSubmitURL" />
@endsection

@section('script')

<script>
const input = document.querySelector("#full_number");
var iti = window.intlTelInput(input, {
    initialCountry: "mt",
    utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@23.1.0/build/js/utils.js",
});

$("#full_number").on("blur", function() {
    var completeNumber = iti.getNumber();
    const countryData = iti.getSelectedCountryData();
    const countryCode = countryData.dialCode;
    const countryName = countryData.name;
    $('#country').val(countryName);
    $('#mobile_no').val(completeNumber);
    // You can also set this value in another element or use it as needed
});
</script>
@endsection