<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@23.1.0/build/css/intlTelInput.css">
<div class="modal fade" id="signUpModal" data-backdrop="static" data-keyboard="false" tabindex="1" role="dialog"
    aria-labelledby="signUpModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-body">
                <div class="account-form-area">
                    <button type="button" class="close-btn" data-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                    <h3 class="title">Open Free Account</h3>

                    <div class="account-form-wrapper" id="registerNewUser">
                        <div id="registerStatusMessage"></div>
                        <form id="bmi_Register_New_Account" method="POST"
                            action="{{ route('frontend.register-account.store') }}">
                            <div class="row">
                                @csrf
                                <div class="form-group col-md-6 col-sm-12 mt-3">
                                    <label class="mb-1">First Name <sup>*</sup></label>
                                    <input type="text" name="first_name" required id="first_name"
                                        placeholder="First Name" />
                                </div>

                                <div class="form-group col-md-6 col-sm-12 mt-3">
                                    <label class="mb-1">Last Name <sup>*</sup></label>
                                    <input type="text" name="last_name" required id="last_name"
                                        placeholder="Last Name" />
                                </div>

                                <div class="form-group col-md-6 col-sm-12 mt-3">
                                    <label class="mb-1">Email <sup>*</sup></label>
                                    <input type="email" name="email" required id="email"
                                        placeholder="Enter your Email"
                                        pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,}$" />
                                </div>

                                <div class="form-group col-md-6 col-sm-12 mt-3">
                                    <label class="mb-1">Phone Number <sup>*</sup></label>
                                    <input type="text" class="w-100" max="10" maxlength="10" id="full_number"
                                        placeholder="Enter Your Phone No">

                                    <input type="hidden" name="country_code" id="country_code">
                                    <input type="hidden" name="phone_number" id="phone_number">
                                    <input type="hidden" name="iso2" id="country_iso">
                                </div>

                                <div class="form-group col-md-6 col-sm-12 mt-3">
                                    <label class="mb-1">password <sup>*</sup></label>
                                    <input type="password" name="password" min="8" minlength="8" required
                                        id="reg_password" placeholder="Password" />
                                </div>

                                <div class="form-group col-md-6 col-sm-12 mt-3">
                                    <label class="mb-1">confirm password <sup>*</sup></label>
                                    <input type="password" name="confirm_password" min="8" minlength="8"
                                        required id="reg_confirm_password" placeholder="Confirm Password" />
                                </div>

                                <div class="form-group col-md-6 col-sm-12 mt-3">
                                    <label class="mb-1">Date of Birth <sup>*</sup></label>
                                    <input type="text" name="dob" class="datePicker" required id="dob"
                                        placeholder="dd/mm/yyyy" />
                                    <div id="dobFeedback" class="form-text text-danger"></div>
                                </div>

                                <div class="form-group col-md-6 col-sm-12 mt-3">
                                    <label class="mb-1">Gender <sup>*</sup></label>
                                    <select class="input_fields value" required name="gender" style="height: 38px;">
                                        <option value="">Select Gender</option>
                                        <option value="male">Male</option>
                                        <option value="female">Female</option>
                                        <option value="other">Other</option>
                                    </select>
                                </div>

                                <div class="form-group col-md-6 col-sm-12 mt-3">
                                    <label class="mb-1">Flat / Door Number<sup></sup></label>
                                    <input type="text" name="flat_no" id="flat_no"
                                        placeholder="E.g., Apartment 101, Door 12A" />
                                </div>

                                <div class="form-group col-md-6 col-sm-12 mt-3">
                                    <label class="mb-1">Landmark<sup></sup></label>
                                    <input type="text" name="landmark" id="landmark"
                                        placeholder="E.g., Near City Mall, Opposite Post Office" />
                                </div>

                                <div class="form-group col-12 mt-3">
                                    <label class="mb-1">Street <sup>*</sup></label>
                                    <input type="text" name="street_address" required id="street_address"
                                        placeholder="E.g., Main Street, Baker’s Lane" />
                                </div>

                                <div class="form-group col-md-6 col-sm-12 mt-3">
                                    <label class="mb-1">City <sup>*</sup></label>
                                    <input type="text" name="city" required id="city"
                                        placeholder="E.g., New York, Los Angeles" />
                                </div>

                                <div class="form-group col-md-6 col-sm-12 mt-3">
                                    <label class="mb-1">State / Province <sup></sup></label>
                                    <input type="text" name="state" id="state"
                                        placeholder="E.g., California, Texas" />
                                </div>

                                <div class="form-group col-md-6 col-sm-12 mt-3">
                                    <label class="mb-1">Postal Code <sup></sup></label>
                                    <input type="tel" name="postal_code" id="postal_code"
                                        placeholder="E.g., 90001" maxlength="6" max="6" min="4" />
                                </div>

                                <div class="form-group col-md-6 col-sm-12 mt-3">
                                    <label class="mb-1">Country <sup>*</sup></label>
                                    <select class="input_fields" name="country" required id="country"
                                        style="height: 38px;">
                                        <option value="">Select Country</option>
                                        @foreach (\App\Models\Country::get() as $country)
                                            <option value="{{ $country->nicename }}">{{ $country->nicename }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="d-flex flex-wrap mt-3 col-12">
                                    <div class="custom-control custom-checkbox link">
                                        <input type="checkbox" class="custom-control-input" id="termsCheckbox"
                                            name="termsCheckbox" />
                                        <label class="custom-control-label" style="padding: 4px 0px;"
                                            for="termsCheckbox">
                                            I accept the <a href="{{ route('term.services') }}" target="_blank">Terms
                                                & Conditions</a>
                                            &
                                            <a href="{{ route('privacy') }}" target="_blank">Privacy
                                                Policy</a>.</label>
                                    </div>
                                </div>

                                <div class="d-flex flex-wrap mt-2 col-12">
                                    <div class="custom-control custom-checkbox link">
                                        <input type="checkbox" class="custom-control-input" id="ageConfirmation"
                                            name="ageConfirmation" />
                                        <label class="custom-control-label" style="padding: 4px 0px;"
                                            for="ageConfirmation">
                                            I hereby confirm that I am 18 years of age or older.</label>
                                    </div>
                                </div>


                                <div class="form-group col-12 mt-4" style="">
                                    {{-- display: flex;flex-direction: row;align-items: center;justify-content: space-between; --}}
                                    <div class="row">
                                        <div class="col-md-6 col-sm-12">
                                            <button type="submit" id="registerButton" style="width: auto;"
                                                class="cmn-btn">Create Account</button>
                                        </div>

                                        <div class="col-md-6 col-sm-12 text-white mt-4">
                                            Already have an account?
                                            <a href="javascript:0;" data-backdrop="static" data-keyboard="false"
                                                class="loginModal openLoginModal" data-target="#loginModal_"
                                                id="showLoginModalButton">Login</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>

                        <div class="divider">
                            <span>or</span>
                        </div>
                        <ul class="social-link-list">
                            <li>
                                <a href="{{ route('frontend.auth.socialite.redirect', 'facebook') }}"><i
                                        class="fab fa-facebook-f"></i></a>
                            </li>
                            <li>
                                <a href="#0"><i class="fab fa-twitter"></i></a>
                            </li>
                            <li>
                                <a href="{{ route('frontend.auth.socialite.redirect', 'google') }}"><i
                                        class="fab fa-google"></i></a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="signUpSuccessModal" data-backdrop="static" data-keyboard="false" tabindex="1"
    role="dialog" aria-labelledby="signUpSuccessModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-body">
                <div class="account-form-area">
                    <button type="button" class="close-btn" data-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                    <h3 class="title">Success message!</h3>

                    <div class="account-form-wrapper text-center text-white" id="registerNewUserPopUp">
                        You have successfully registered. We have sent an activation link to your registered email.
                        Please check and activate your account.
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const registerTogglePassword = document.querySelector('#registerTogglePassword');
        const passwordField = document.querySelector('#login_password');
        const registerTogglePasswordIcon = document.querySelector('#registerTogglePasswordIcon');

        registerTogglePassword.addEventListener('click', function() {
            // Toggle the type attribute
            const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordField.setAttribute('type', type);

            // Toggle the icon
            registerTogglePasswordIcon.innerHTML = (type === 'password') ? '<i class="fa fa-eye"></i>' :
                '<i class="fa fa-eye-slash"></i>';
        });
    });
</script>
