<div class="modal fade questionModal" data-backdrop="static" data-keyboard="false" id="questionModal" tabindex="1"
    role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-body">
                <div class="account-form-area">
                    <button type="button" class="close-btn" data-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                    <h3 class="title">Question and Answer</h3>
                    <div id="answerMessage"></div>
                    <div class="account-form-wrapper" id="question-form-wrapper"></div>
                </div>
            </div>
        </div>
    </div>
</div>

<input type="hidden" id="QuestionURL" value="{{ route('frontend.user.get.questions') }}" />
<script src="{{ asset('frontend/assets/js/vendor/jquery-3.5.1.min.js') }}"></script>
<script>
    function getQuestion() {
        $.ajax({
            url: $("#QuestionURL").val(),
            method: 'GET',
            success: function(response) {
                $('#question-form-wrapper').html(response);
            }
        });
    }

    getQuestion();

    $(document).on('submit', '#userQuestionsAnswerForm', function(e) {
        e.preventDefault();
        var formDate = $("#userQuestionsAnswerForm").serialize();
        var statusOn = $("#answerMessage");
        statusOn.empty();
        $.ajax({
            url: "{{ route('frontend.user.save.question.answer') }}",
            method: 'POST',
            data: formDate,
            success: function(data) {
                if (data.status === true) {
                    statusOn.prepend(
                        $('<div class="alert mt-1 alert-success alert-dismissible">' +
                            '<a href="javascript:0;" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>' +
                            data.message +
                            '</div>').hide()
                        .fadeIn(1000)
                        .delay(3000) // Wait for 3 seconds
                        .fadeOut(1500, function() {
                            $(this)
                                .remove(); // Remove the element from DOM after fading out
                        })
                    );
                    $("#userQuestionsAnswerForm").trigger("reset");
                    setInterval(() => {
                        window.location = "{{ route('frontend.user.checkout.cart') }}";
                    }, 2500);
                } else {
                    if (data.remaining_attempts) {
                        setInterval(() => {
                            location.reload();
                        }, 1500);
                    }
                    statusOn.prepend(
                        $('<div class="alert mt-1 alert-danger alert-dismissible">' +
                            '<a href="javascript:0;" class="close" data-dismiss="alert" aria-label="close" title="close">×</a>' +
                            data.message + '</div>').hide()
                        .fadeIn(1000)
                        .delay(3000) // Wait for 3 seconds
                        .fadeOut(1500, function() {
                            $(this)
                                .remove(); // Remove the element from DOM after fading out
                        })
                    );
                }
            },
            error: function(err) {
                console.log(err);
                statusOn.prepend(
                    $(
                        '<div class="alert mt-1 alert-danger alert-dismissible"> <a href="javascript:0;" class="close" data-dismiss="alert" aria-label="close" title="close">×</a> Sorry, Something wrong. try again later.</div>'
                    )
                    .hide()
                    .fadeIn(1000)
                    .delay(3000) // Wait for 3 seconds
                    .fadeOut(1500, function() {
                        $(this)
                            .remove(); // Remove the element from DOM after fading out
                    })
                );
                return;
            },
        });
    });
</script>
