<style>
    .password-wrapper {
        position: relative;
        display: flex;
        align-items: center;
    }

    #togglePassword {
        background: none;
        border: none;
        cursor: pointer;
        position: absolute;
        right: 48px;
    }

    #togglePasswordIcon {
        font-size: 0.8em;
    }
</style>
<div class="modal fade" id="loginModal" data-backdrop="static" data-keyboard="false" tabindex="1" style="z-index: 99999999;"
    role="dialog" aria-labelledby="loginModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-body">
                <div class="account-form-area">
                    <button type="button" class="close-btn" data-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                    <h3 class="title">Welcome Back</h3>
                    <div class="account-form-wrapper" id="loginUser">
                        <div id="loginStatusMessage"></div>
                        <form id="bmi_login_Account" method="POST"
                            action="{{ route('frontend.login-access') }}?redirect_url={{ urlencode(request()->fullUrl()) }}">
                            @csrf
                            <div class="form-group">
                                <label>Email <sup>*</sup></label>
                                <input type="email" name="email" id="login_email" required
                                    placeholder="Enter your Email" />
                            </div>
                            <div class="form-group">
                                <label>password <sup>*</sup></label>
                                <input type="password" name="password" required id="login_password"
                                    placeholder="password" />
                                <button type="button" id="togglePassword" class="toggle-password">
                                    <span id="togglePasswordIcon">
                                        <i class="fa fa-eye"></i>
                                    </span>
                                </button>
                            </div>
                            <div class="mt-2 pt-1 d-flex justify-content-between">

                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" id="rememberMe"
                                        name="remember_me" value="1">
                                    <label class="custom-control-label" style="padding: 4px 0px;" for="rememberMe">
                                        Remember Password</label>
                                </div>

                                <a href="javascript:0;" id="showForgetPasswordModalButton"
                                    class="forgetPasswordModal openForgetPasswordModal" data-backdrop="static"
                                    data-keyboard="false" data-toggle="modal" data-target="#forgetPasswordModal_"
                                    class="link">Forgot Password?</a>
                            </div>
                            <div class="form-group text-center mt-5">
                                <button class="cmn-btn">log in</button>
                            </div>
                        </form>
                        <p class="text-center mt-4">
                            Don’t have an account?
                            <a href="javascript:0;" id="showSignUpModalButton" class="signUpModal openSignUpModal"> Sign
                                Up Now</a>
                            {{-- data-backdrop="static" data-keyboard="false" --}}
                            {{-- data-toggle="modal" data-target="#signUpModal_" --}}
                        </p>
                        <div class="divider">
                            <span>or</span>
                        </div>
                        <ul class="social-link-list">
                            <li>
                                <a href="{{ route('frontend.auth.socialite.redirect', 'facebook') }}"><i
                                        class="fab fa-facebook-f"></i></a>
                            </li>
                            {{-- <li>
                                <a href="javascript:0;"><i class="fab fa-twitter"></i></a>
                            </li> --}}
                            <li>
                                <a href="{{ route('frontend.auth.socialite.redirect', 'google') }}"><i
                                        class="fab fa-google"></i></a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const togglePassword = document.querySelector('#togglePassword');
        const passwordField = document.querySelector('#login_password');
        const togglePasswordIcon = document.querySelector('#togglePasswordIcon');

        togglePassword.addEventListener('click', function() {
            // Toggle the type attribute
            const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordField.setAttribute('type', type);

            // Toggle the icon
            togglePasswordIcon.innerHTML = (type === 'password') ? '<i class="fa fa-eye"></i>' :
                '<i class="fa fa-eye-slash"></i>';
        });
    });
</script>
