@extends('layouts.frontend.master')
@section('title', 'BMF')

@section('css')
@endsection

@section('style')
@endsection

@section('content')
    <!-- inner-hero-section start -->
    <div class="inner-hero-section">
        <div class="bg-shape"><img src="{{ asset('frontend/assets/images/elements/inner-hero-shape.png') }}" alt="image">
        </div>
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <ul class="page-list">
                        <li><a href="{{ route('home') }}">Home</a></li>
                        <li><a href="{{ route('frontend.cart') }}">My Cart</a></li>
                        <li class="active">Checkout</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- inner-hero-section end -->

    <!-- cart section start -->
    <section class="pb-120 mt-minus-300">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    @include('layouts.alerts')

                    <div class="checkout-area">
                        <form class="personal-details-form" action="{{ route('frontend.user.checkout.index') }}"
                            method="POST">
                            @csrf
                            <div class="row">
                                @php
                                    $totalAmount = 0;
                                    foreach ($cartItems as $key => $value) {
                                        $totalAmount += $value->price * $value->quantity;
                                    }
                                @endphp
                                <div class="col-lg-7">
                                    <div class="checkout-form-area">
                                        <div class="top">
                                            <div class="left">
                                                <h3 class="mb-2">{{ request()->user()->name ?? 'Something worng!' }}</h3>
                                                <p>{{ request()->user()->email ?? '' }}</p>
                                            </div>
                                            @if (!Auth::check())
                                                <div class="right">
                                                    <a href="javascript:0;" data-toggle="modal" data-backdrop="static"
                                                        data-keyboard="false" data-target="#loginModal">
                                                        <i class="las la-user"></i> <span>Sign in</span>
                                                    </a>
                                                </div>
                                            @endif
                                        </div><!-- top end -->
                                        <div class="personal-details mt-30">
                                            <h3 class="title">Share your Contact Details </h3>
                                            <input type="hidden" name="user" value="{{ request()->user()->id }}" />
                                            <div class="form-row">
                                                <div class="form-group col-lg-6">
                                                    <input type="text" name="name" required placeholder="Full Name"
                                                        value="{{ request()->user()->name ?? '' }}">
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <input type="email" name="email" required
                                                        placeholder="Enter your Mail"
                                                        value="{{ request()->user()->email ?? '' }}">
                                                </div>
                                                <div class="form-group col-lg-6">
                                                    <input type="text" name="mobile" required
                                                        placeholder="Enter your Phone Number"
                                                        value="{{ request()->user()->additional_info?->phone ?? '' }}">
                                                </div>
                                            </div>

                                        </div><!-- personal-details end -->

                                    </div><!-- checkout-form-area end -->
                                </div>

                                <div class="col-lg-5 mt-lg-0 mt-4">
                                    <div class="checkout-wrapper">
                                        <div class="checkout-wrapper__header">
                                            <h3>Checkout</h3>
                                        </div>
                                        <div class="checkout-wrapper__body">
                                            <ul class="price">
                                                @php
                                                    $totalAmount = 0;
                                                @endphp
                                                @foreach ($cartItems as $key => $value)
                                                    @php
                                                        $contest = $value->item;
                                                    @endphp
                                                    <li id="cartItemRight{{ $value->id }}">
                                                        <input type="hidden" name="item[{{ $key }}][id]"
                                                            value="{{ $value->item_id }}" />
                                                        <input type="hidden" name="item[{{ $key }}][quantity]"
                                                            value="{{ $value->quantity }}" />
                                                        <input type="hidden" name="item[{{ $key }}][price]"
                                                            value="{{ $value->price }}" />
                                                        <input type="hidden" name="item[{{ $key }}][total_price]"
                                                            value="{{ $value->total_price }}" />
                                                        <div class="left">
                                                            <h4 class="caption">{{ $contest->title }}</h4>
                                                            <span>({{ $value->quantity }} x
                                                                {{ config('app.currency_symbol') }}{{ $value->price }})</span>
                                                        </div>
                                                        <div class="right">
                                                            <span
                                                                class="price">{{ config('app.currency_symbol') }}{{ $value->price * $value->quantity }}</span>
                                                        </div>
                                                    </li>
                                                    @php
                                                        $totalAmount += $value->price * $value->quantity;
                                                    @endphp
                                                @endforeach
                                                <li>
                                                    <div class="left">
                                                        <h4 class="caption">Total</h4>
                                                    </div>
                                                    <div class="right">
                                                        <span
                                                            class="price total_amount">{{ config('app.currency_symbol') }}{{ $totalAmount }}</span>
                                                    </div>
                                                </li>
                                            </ul>

                                            <div class="form-group col-lg-12 text-center mt-3">
                                                <button type="submit" class="cmn-btn">
                                                    Pay
                                                    {{ config('app.currency_symbol') }}{{ number_format($totalAmount, 2) }}
                                                </button>
                                            </div>
                                        </div>
                                    </div><!-- checkout-wrapper end -->
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- cart section end -->
@endsection

@section('script')
    <script>
        $(document).ready(function() {
            $("#emptyCart").click(function() {
                let deleteAllUrl = $(this).data('url');
                $.ajax({
                    url: deleteAllUrl,
                    method: "GET",
                    success: function(response) {
                        if (response.status == true) {
                            location.reload();
                        }

                        getCartItemsCount($("#getCartItemsURL").val());
                        return true;
                    }
                })
            });
        });

        $(document).on("click", ".delete_cart_item", function(e) {
            e.preventDefault();
            let deleteItemUrl = $(this).data('url');
            let cartItemId = $(this).data('cart_item_id');
            $.ajax({
                url: deleteItemUrl,
                method: "GET",
                success: function(response) {
                    if (response.status == true) {
                        $("#cartItemleft" + cartItemId).remove();
                        $("#cartItemRight" + cartItemId).remove();

                        if (response.count == 0) {
                            location.reload();
                        }
                    }


                    getCartItemsCount($("#getCartItemsURL").val());
                    return true;
                }
            })
        })
    </script>
@endsection
