@extends('layouts.frontend.master')
@section('title', 'BMF')

@section('css')
@endsection

@section('style')
    <style>
        @media(min-width:576.99px) {
            .ticket-wrapper__body .single-row .left {
                width: calc(100% - 100px);
            }
        }
    </style>
@endsection

@section('content')
    <!-- inner-hero-section start -->
    <div class="inner-hero-section">
        <div class="bg-shape"><img src="{{ asset('frontend/assets/images/elements/inner-hero-shape.png') }}" alt="image">
        </div>
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <ul class="page-list">
                        <li><a href="{{ route('home') }}">Home</a></li>
                        <li class="active">My Cart</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- inner-hero-section end -->

    <!-- cart section start -->
    <section class="pb-120 mt-minus-300">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="cart-wrapper">
                        <h2 class="cart-wrapper__title">My Cart</h2>
                        <div class="row justify-content-lg-between">

                            @if (count($cartItems) > 0)
                                <div class="col-lg-7">
                                    <div class="ticket-wrapper">
                                        <div class="ticket-wrapper__header">
                                            <h3>Your tickets:</h3>
                                            <button type="button" data-url="{{ route('frontend.empty.cart.items') }}"
                                                id="emptyCart">clear all</button>
                                        </div>
                                        <div class="ticket-wrapper__body">
                                            @foreach ($cartItems as $key => $value)
                                                @php
                                                    $contest = $value->item;
                                                @endphp
                                                <div class="single-row" id="cartItemleft{{ $value->id }}">
                                                    <div class="left">
                                                        <h4 class="caption">{{ $contest->title }}</h4>
                                                        {{-- <div class="select-quantity">
                                                            <input type="hidden" id="contest_id" value="{{$contest->id}}" />
                                                            <div class="quantity">
                                                                <input type="number" id="quantity" min="1" max="{{$contest->qty}}" step="1" value="{{$value->quantity}}" readonly />
                                                            </div>
                                                        </div> --}}
                                                        <span>{{ $value->quantity }} x
                                                            {{ config('app.currency_symbol') }}{{ $value->price }}</span>
                                                    </div>
                                                    <div class="action-btns">
                                                        <button type="button" data-cart_item_id="{{ $value->id }}"
                                                            data-url="{{ route('frontend.delete.cart.item', ['id' => $value->id]) }}"
                                                            class="del-btn delete_cart_item"><i
                                                                class="las la-trash-alt"></i></button>
                                                    </div>
                                                </div><!-- single-row end -->
                                            @endforeach
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 mt-lg-0 mt-4">
                                    <div class="checkout-wrapper">
                                        <div class="checkout-wrapper__header">
                                            <h3>Your tickets:</h3>
                                        </div>
                                        <div class="checkout-wrapper__body">
                                            <ul class="price">
                                                @php
                                                    $totalAmount = 0;
                                                @endphp
                                                @foreach ($cartItems as $key => $value)
                                                    @php
                                                        $contest = $value->item;
                                                    @endphp
                                                    <li id="cartItemRight{{ $value->id }}">
                                                        <div class="left">
                                                            <h4 class="caption">{{ $contest->title }}</h4>
                                                            <span>({{ $value->quantity }} x
                                                                {{ config('app.currency_symbol') }}{{ $value->price }})</span>
                                                        </div>
                                                        <div class="right">
                                                            <span
                                                                class="price">{{ config('app.currency_symbol') }}{{ $value->price * $value->quantity }}</span>
                                                        </div>
                                                    </li>
                                                    @php
                                                        $totalAmount += $value->price * $value->quantity;
                                                    @endphp
                                                @endforeach
                                                <li>
                                                    <div class="left">
                                                        <h4 class="caption">Total</h4>
                                                    </div>
                                                    <div class="right">
                                                        <span
                                                            class="price total_amount">{{ config('app.currency_symbol') }}{{ $totalAmount }}</span>
                                                    </div>
                                                </li>
                                            </ul>
                                            <div class="checkout-wrapper__btn">
                                                @if (Auth::check())
                                                    {{-- {{ route('frontend.user.checkout.cart') }} --}}
                                                    <a href="javascript:0;" data-backdrop="static" data-keyboard="false"
                                                        data-toggle="modal" data-target="#questionModal"
                                                        class="cmn-btn">Checkout Cart</a>
                                                @else
                                                    <a class="cmn-btn" data-backdrop="static" data-keyboard="false"
                                                        href="javascript:0;" data-toggle="modal" data-target="#loginModal"
                                                        data-backdrop="static" data-keyboard="false">Checkout Cart</a>
                                                @endif
                                            </div>
                                        </div>
                                    </div><!-- checkout-wrapper end -->
                                    <div class="mt-50">
                                        <img src="{{ asset('frontend/assets/images/elements/payment.png') }}"
                                            alt="image" class="mt-30">
                                    </div>
                                </div>
                            @else
                                <div class="col-lg-12 text-center">
                                    <h5>Cart Empty</h5>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="col-lg-12 pt-120">
                    <div class="pick-lottery-package">
                        <h2 class="title">Featured Contests</h2>
                        @php
                            $favContests = Auth::user()->favContests ?? [];
                            $favContestsIds = [];
                            foreach ($favContests as $key => $favContest) {
                                $favContestsIds[] = $favContest->contest_id;
                            }
                        @endphp
                        <div class="row mb-none-30">
                            @foreach ($contests as $key => $contest)
                                @include('application.contest.contast-card', ['contest' => $contest])
                            @endforeach
                        </div>
                    </div>
                </div><!-- col-lg-12 -->
            </div>
        </div>
    </section>
    <!-- cart section end -->
@endsection

@section('script')
    <script>
        $(document).ready(function() {
            $("#emptyCart").click(function() {
                let deleteAllUrl = $(this).data('url');
                $.ajax({
                    url: deleteAllUrl,
                    method: "GET",
                    success: function(response) {
                        if (response.status == true) {
                            location.reload();
                        }

                        getCartItemsCount($("#getCartItemsURL").val());
                        return true;
                    }
                })
            });
        });

        $(document).on("click", ".delete_cart_item", function(e) {
            e.preventDefault();
            let deleteItemUrl = $(this).data('url');
            let cartItemId = $(this).data('cart_item_id');
            $.ajax({
                url: deleteItemUrl,
                method: "GET",
                success: function(response) {
                    if (response.status == true) {
                        $("#cartItemleft" + cartItemId).remove();
                        $("#cartItemRight" + cartItemId).remove();

                        if (response.count == 0) {
                            location.reload();
                        }
                    }


                    getCartItemsCount($("#getCartItemsURL").val());
                    return true;
                }
            })
        })
    </script>
@endsection
