@extends('layouts.frontend.master')
@section('title', 'About us')

@section('css')
@endsection

@section('style')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" />
@endsection

@section('content')
<div class="inner-hero-section style--four">
    <div class="bg-shape"><img src="{{asset('frontend/assets/images/elements/inner-hero-shape-2.png')}}" alt="image">
    </div>
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <ul class="page-list">
                    <li><a href="{{route('home')}}">Home</a></li>
                    <li class="active">About Us</li>
                </ul>
            </div>
        </div>
    </div>
</div>
<!-- inner-hero-section end -->

<!-- about section start -->
<section class="mt-minus-150">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="about-wrapper pt-120">
                    <div class="about-wrapper__header">
                        <div class="about-wrapper__title-top">{{$aboutUsIntro->title ?? 'A few words about us'}}</div>
                        <h2 class="about-wrapper__title">
                            {{$aboutUsIntro->sub_title ?? 'We dream big so you can win big'}}</h2>
                    </div>
                    <div class="about-wrapper__content">
                        <div class="description_box text-white">{!! $aboutUsIntro->description ?? '<p>Our team of
                                creative programmers, marketing experts, and members of the global lottery community
                                have worked together to build the ultimate lottery site, and every win and happy
                                customer reminds us how lucky we are to be doing what we love.</p>' !!}</div>
                    </div>
                </div><!-- about-wrapper-->

                @php
                $introCounts = !empty($aboutUsIntro->value)?json_decode($aboutUsIntro->value):null;
                @endphp

                <div style="display: none;" class="row counter-wrapper style--two mb-none-30 justify-content-center">
                    <div class="col-lg-4 col-sm-6 text-center mb-30">
                        <div class="counter-item style--two">
                            <div class="counter-item__content">
                                <span>{{$introCounts->winner_of_month ?? '23'}}</span>
                                <p>Winners For Last Month</p>
                            </div>
                        </div>
                    </div><!-- counter-item end -->
                    <div class="col-lg-4 col-sm-6 text-center mb-30">
                        <div class="counter-item style--two">
                            <div class="counter-item__content">
                                <span>{{$introCounts->ticket_sold ?? '2837K'}}</span>
                                <p>Tickets Sold</p>
                            </div>
                        </div>
                    </div><!-- counter-item end -->
                    <div class="col-lg-4 col-sm-6 text-center mb-30">
                        <div class="counter-item style--two">
                            <div class="counter-item__content">
                                <span>{{$introCounts->payouts_winner ?? '28387K'}}</span>
                                <p>Payouts to Winners</p>
                            </div>
                        </div>
                    </div><!-- counter-item end -->
                </div>

            </div>
        </div>
    </div>
</section>
<!-- about section end -->

<!-- features section start -->
<section class="pt-120 pb-120 position-relative">
    <div class="feature-car">
        @if(!empty($aboutUsWhatsDiffIntro->image) && Storage::exists($aboutUsWhatsDiffIntro->image))
        <img src="{{asset(Storage::url($aboutUsWhatsDiffIntro->image))}}" alt="image-icon" />
        @else
        <img src="{{asset('frontend/assets/images/elements/feature-car.png')}}" alt="image">
        @endif
    </div>

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="section-header text-center">
                    <span
                        class="section-sub-title">{{$aboutUsWhatsDiffIntro->sub_title ?? 'An Exhaustive list of amazing features'}}</span>
                    <h2 class="section-title style--two">
                        {{$aboutUsWhatsDiffIntro->title ?? 'What makes BMF Competitions different?'}}</h2>
                    <div class="description_box text-white">{!! $aboutUsWhatsDiffIntro->description ?? '<p>These are the
                            key drivers that make us different: Safe, Social, Reliable and Fun. BMF Competitions Lotto
                            is dedicated to trust and safety.</p>' !!}</div>
                </div>
            </div>
        </div>

        <div class="row align-items-center">
            <div class="col-xl-9">
                <div class="row mb-none-30">
                    @php
                    $aboutUsWhatsDiffStepOne = $aboutUsWhatsDiffIntro->moreRelatedData[0] ?? null;
                    $aboutUsWhatsDiffStepTwo = $aboutUsWhatsDiffIntro->moreRelatedData[1] ?? null;
                    $aboutUsWhatsDiffStepThree = $aboutUsWhatsDiffIntro->moreRelatedData[2] ?? null;
                    $aboutUsWhatsDiffStepFour = $aboutUsWhatsDiffIntro->moreRelatedData[3] ?? null;
                    $aboutUsWhatsDiffStepFive = $aboutUsWhatsDiffIntro->moreRelatedData[4] ?? null;
                    $aboutUsWhatsDiffStepSix = $aboutUsWhatsDiffIntro->moreRelatedData[5] ?? null;
                    @endphp

                    <div class="col-lg-4 col-sm-6 mb-30">
                        <div class="feature-card style--two">
                            <div class="feature-card__icon">
                                <div class="inner">
                                    @if(!empty($aboutUsWhatsDiffStepOne->image) &&
                                    Storage::exists($aboutUsWhatsDiffStepOne->image))
                                    <img src="{{asset(Storage::url($aboutUsWhatsDiffStepOne->image))}}"
                                        alt="image-icon" />
                                    @else
                                    <img src="{{asset('frontend/assets/images/icon/feature/5.png')}}" alt="image">
                                    @endif
                                </div>
                            </div>
                            <div class="feature-card__content">
                                <h3>{{$aboutUsWhatsDiffStepOne->title ?? 'No Commission on Winnings'}}</h3>
                            </div>
                        </div>
                    </div>


                    <div class="col-lg-4 col-sm-6 mb-30">
                        <div class="feature-card style--two">
                            <div class="feature-card__icon">
                                <div class="inner">
                                    @if(!empty($aboutUsWhatsDiffStepTwo->image) &&
                                    Storage::exists($aboutUsWhatsDiffStepTwo->image))
                                    <img src="{{asset(Storage::url($aboutUsWhatsDiffStepTwo->image))}}"
                                        alt="image-icon" />
                                    @else
                                    <img src="{{asset('frontend/assets/images/icon/feature/6.png')}}" alt="image">
                                    @endif
                                </div>
                            </div>
                            <div class="feature-card__content">
                                <h3>{{$aboutUsWhatsDiffStepTwo->title ?? 'Safe and Secure Playing'}}</h3>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-sm-6 mb-30">
                        <div class="feature-card style--two">
                            <div class="feature-card__icon">
                                <div class="inner">
                                    @if(!empty($aboutUsWhatsDiffStepThree->image) &&
                                    Storage::exists($aboutUsWhatsDiffStepThree->image))
                                    <img src="{{asset(Storage::url($aboutUsWhatsDiffStepThree->image))}}"
                                        alt="image-icon" />
                                    @else
                                    <img src="{{asset('frontend/assets/images/icon/feature/7.png')}}" alt="image">
                                    @endif
                                </div>
                            </div>
                            <div class="feature-card__content">
                                <h3>{{$aboutUsWhatsDiffStepThree->title ?? 'Biggest lottery jackpots'}}</h3>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-sm-6 mb-30">
                        <div class="feature-card style--two">
                            <div class="feature-card__icon">
                                <div class="inner">
                                    @if(!empty($aboutUsWhatsDiffStepFour->image) &&
                                    Storage::exists($aboutUsWhatsDiffStepFour->image))
                                    <img src="{{asset(Storage::url($aboutUsWhatsDiffStepFour->image))}}"
                                        alt="image-icon" />
                                    @else
                                    <img src="{{asset('frontend/assets/images/icon/feature/8.png')}}" alt="image">
                                    @endif
                                </div>
                            </div>
                            <div class="feature-card__content">
                                <h3>{{$aboutUsWhatsDiffStepFour->title ?? 'Instant payout system'}}</h3>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-sm-6 mb-30">
                        <div class="feature-card style--two">
                            <div class="feature-card__icon">
                                <div class="inner">
                                    @if(!empty($aboutUsWhatsDiffStepFive->image) &&
                                    Storage::exists($aboutUsWhatsDiffStepFive->image))
                                    <img src="{{asset(Storage::url($aboutUsWhatsDiffStepFive->image))}}"
                                        alt="image-icon" />
                                    @else
                                    <img src="{{asset('frontend/assets/images/icon/feature/9.png')}}" alt="image">
                                    @endif
                                </div>
                            </div>
                            <div class="feature-card__content">
                                <h3>{{$aboutUsWhatsDiffStepFive->title ?? 'Dedicated Support'}}</h3>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-sm-6 mb-30">
                        <div class="feature-card style--two">
                            <div class="feature-card__icon">
                                <div class="inner">
                                    @if(!empty($aboutUsWhatsDiffStepSix->image) &&
                                    Storage::exists($aboutUsWhatsDiffStepSix->image))
                                    <img src="{{asset(Storage::url($aboutUsWhatsDiffStepSix->image))}}"
                                        alt="image-icon" />
                                    @else
                                    <img src="{{asset('frontend/assets/images/icon/feature/10.png')}}" alt="image">
                                    @endif
                                </div>
                            </div>
                            <div class="feature-card__content">
                                <h3>{{$aboutUsWhatsDiffStepSix->title ?? 'Unlimited Affiliates'}}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- row end -->
    </div>
</section>
<!-- features section end -->

@if($testimonials->count())
<!-- testimonial section start -->
<section style="display: none" class="has-bg--shape pt-120 pb-120">
    <div class="bg-shape">
        <div class="round-shape d-sm-block d-none"><img
                src="{{asset('frontend/assets/images/elements/round-shape.png')}}" alt="image">
        </div>
        <div class="shape-1"></div>
        <div class="shape-2"></div>
        <div class="shape-3"></div>
        <div class="shape-4"></div>
        <div class="shape-5"></div>
        <div class="shape-6"></div>
    </div>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-9">
                <div class="section-header text-center">
                    <span class="section-sub-title">{{$aboutUsTestimonialIntro->title ?? 'Testimonial'}}</span>
                    <h2 class="section-title">
                        {{$aboutUsTestimonialIntro->sub_title ?? 'our Happy Customers All Around the World'}}</h2>
                    <div class="description_box text-white">{!!$aboutUsTestimonialIntro->description ?? '<p>With over 12
                            years of experience as the world’s leading online lottery service provider. Find out what
                            our members have to say about us!</p>'!!}</div>
                </div>
            </div>
        </div>
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="testimonial-area bg_img"
                    data-background="{{asset('frontend/assets/images/elements/testimonial-single.jpg')}}">
                    <div class="testimonial-slider">
                        @foreach ($testimonials as $key => $testimonial)
                        <div class="testimonial-single">
                            <div class="testimonial-single__thumb">
                                @if(!empty($testimonial->image) && Storage::exists($testimonial->image))
                                <img src="{{asset(Storage::url($testimonial->image))}}" alt="{{$testimonial->name}}">
                                @else
                                <img src="{{asset('frontend/assets/images/winner/2.png')}}" alt="image">
                                @endif
                            </div>
                            <div class="testimonial-single__content">
                                <h4 class="client-name">{{$testimonial->name}}</h4>
                                <p>{{$testimonial->description}}</p>
                                <div class="ratings">
                                    @php
                                    $rating = round((int) $testimonial->value) ?? 3;
                                    @endphp
                                    @for ($i = 0; $i < 5; $i++) @if($i < $rating) <i class="fas fa-star"></i>
                                        @else
                                        <i class="fa-regular fa-star"></i>
                                        @endif
                                        @endfor
                                </div>
                            </div>
                        </div><!-- testimonial-single end -->
                        @endforeach
                    </div><!-- testimonial-slider end -->
                </div><!-- testimonial-area end -->
            </div>
        </div>
    </div>
</section>
<!-- testimonial section end -->
@endif

@if($teamMembers->count())
<!-- team section start -->
<section style="display: none" class="pb-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-9">
                <div class="section-header text-center">
                    <span class="section-sub-title"> {{$aboutUsTeamIntro->title ?? 'Meet Our most Valued'}}</span>
                    <h2 class="section-title style--two">{{$aboutUsTeamIntro->sub_title ?? 'Expert Team Members'}}</h2>
                    <div class="description_box text-white">{!!$aboutUsTeamIntro->description ?? '<p>These are the key
                            drivers that make us different: Safe, Social, Reliable and Fun. BMF Competitions Lotto is
                            dedicated to trust and safety</p>'!!}.</div>
                </div>
            </div>
        </div>
        <div class="row mb-none-30 justify-content-center">
            @foreach ($teamMembers as $teamMember)
            <div class="col-lg-4 col-sm-6 mb-30">
                <div class="team-card">
                    <div class="team-card__thumb">
                        @if(!empty($teamMember->image) && Storage::exists($teamMember->image))
                        <img src="{{asset(Storage::url($teamMember->image))}}"
                            style="width: 100%;height: 167px;object-fit: cover;" alt="{{$teamMember->name}}">
                        @else
                        <img src="{{asset('frontend/assets/images/team/1.png')}}" alt="image">
                        @endif

                        <div class="obj"><img src="{{asset('frontend/assets/images/elements/team-obj.png')}}"
                                alt="image"></div>
                    </div>
                    <div class="team-card__content">
                        <h3 class="name">{{$teamMember->name}}</h3>
                        <span class="designation">{{$teamMember->title}}</span>
                    </div>
                </div><!-- team-card end -->
            </div>
            @endforeach
        </div>
    </div>
</section>
@endif
@endsection

@section('script')
@endsection