@extends('layouts.simple.master')
@section('title', 'Users List')

@section('css')
@endsection

@section('style')
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.2/css/dataTables.dataTables.css">
@endsection

@section('breadcrumb-title')
    <h3>Deactivated Users</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">User Management</li>
    <li class="breadcrumb-item active">Deactivated Users</li>
@endsection

@section('content')
    <div class="container-fluid basic_table">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <a class="btn btn-primary btn-sm pull-right" href="{{ route('admin.create-user') }}"
                            data-bs-original-title="" title=""><i class="fa fa-pencil"></i> Add User</a>

                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered" id="usersList">
                                <thead>
                                    <tr>
                                        <th scope="col">Id</th>
                                        <th scope="col">Name</th>
                                        <th scope="col">Email</th>
                                        <th scope="col">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (count($users) > 0)
                                        @foreach ($users as $index => $user)
                                            <tr>
                                                <th scope="row">{{ ++$index }}</th>
                                                <td>{{ $user->name }}</td>
                                                <td>{{ $user->email }}</td>
                                                <td>
                                                    <ul class="action">
                                                        <li class="edit">
                                                            <a onclick="return confirm('Do you want to restore this user?');"
                                                                href="{{ route('admin.delete-user.restore', ['id' => $user->id, 'type' => 'user']) }}"
                                                                data-bs-original-title="" title="">Restore</a>
                                                        </li>
                                                    </ul>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                            {!! $users->links() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        $("#usersList").DataTable({
            "aaSorting": [
                [0, 'desc']
            ],
            "bDestroy": true
        });

        function confirmDelete() {
            return confirm('Are you sure you want to delete this user?');
        }
    </script>
@endsection
