@extends('layouts.simple.master')


@section('css')
@endsection

@section('style')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
@endsection

@section('breadcrumb-title')
    @if (isset($user))
        <h3>Edit User</h3>
    @else
        <h3>Create User</h3>
    @endif
@endsection

@section('breadcrumb-items')
    @if (isset($user))
        <li class="breadcrumb-item">User Management</li>
        <li class="breadcrumb-item">Edit User</li>
    @else
        <li class="breadcrumb-item">User Management</li>
        <li class="breadcrumb-item">Create User</li>
    @endif
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        @if (isset($user))
                            <h5>Edit User</h5>
                        @else
                            <h5>create User</h5>
                        @endif
                    </div>
                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    @php
                        if (isset($user)) {
                            $name = explode(' ', $user?->name);
                            $first_name = $name[0] ?? '';
                            $last_name = $name[1] ?? '';
                        }
                    @endphp
                    <form class="form theme-form" method="post" action="{{ route('admin.store-user') }}">
                        @csrf
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="first_name">First Name</label>
                                        <input class="form-control" id="id" type="hidden" name="id"
                                            value="{{ old('id', isset($user) ? $user->id : '') }}">
                                        <input class="form-control" id="first_name" type="text"
                                            value="{{ old('first_name', isset($first_name) ? $first_name : '') }}"
                                            name="first_name">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="last_name">Last Name</label>
                                        <input class="form-control" id="last_name"
                                            value="{{ old('last_name', isset($last_name) ? $last_name : '') }}"
                                            type="text" name="last_name">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="email">Email address</label>
                                        <input class="form-control" id="email" name="email"
                                            value="{{ old('email', isset($user) ? $user->email : '') }}" type="email"
                                            placeholder="name@example.com">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="password">Password</label>
                                        <input class="form-control" name="password" id="password" type="password"
                                            placeholder="Password">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <label class="form-label" for="role">Role</label>
                                </div>
                                <div class="col">
                                    <div class="m-t-15 m-checkbox-inline custom-radio-ml">
                                        <div class="form-check form-check-inline radio radio-primary">
                                            <input class="form-check-input" id="admin" type="radio" name="role"
                                                value="admin" data-bs-original-title="" title="">
                                            <label class="form-check-label mb-0" for="admin">{{ 'Admin' }}</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card-footer text-end">
                            <button class="btn btn-primary" type="submit">Submit</button>
                            <input class="btn btn-light" type="reset" value="Cancel">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
