@extends('layouts.simple.master')
@section('title', 'Transactions List')

@section('css')
@endsection

@section('style')
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.2/css/dataTables.dataTables.css">
@endsection

@section('breadcrumb-title')
    <h3>Transactions Management</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item active">Transactions Management</li>
@endsection

@section('content')
    <div class="container-fluid basic_table">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <!--<div class="card-header">-->

                    <!--</div>-->
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="transactionsList">
                                <thead>
                                    <tr>
                                        <th scope="col">S.No</th>
                                        <th scope="col">Date</th>
                                        <th scope="col">Description</th>
                                        <th scope="col">Amount</th>
                                        <th scope="col">Quantity</th>
                                        <th scope="col">Payment Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (count($transactions) > 0)
                                        @foreach ($transactions as $key => $transaction)
                                            <tr>
                                                <td>{{ ++$key }}</td>
                                                <td>{{ Carbon\Carbon::parse($transaction->date)->format('d-m-Y H:i:s') }}
                                                </td>
                                                <td><span>{{ $transaction->contest_title }}</span><br><span>Contest No:
                                                        {{ $transaction->contest_no }} </span></td>
                                                <td>{{ config('app.currency_symbol') }}{{ $transaction->grand_total }}</td>
                                                <td>{{ $transaction->quantity }}</td>
                                                <td>
                                                    <div
                                                        class="status-{{ $transaction->payment_status == 'success' ? 'success' : 'pending' }}">
                                                        <b><span
                                                                class="{{ $transaction->payment_status == 'paid' ? 'badge badge-success' : 'badge badge-danger' }}">
                                                                {{ ucwords($transaction->payment_status) }}</span></b>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        $("#transactionsList").DataTable();
    </script>
@endsection
