@extends('layouts.simple.master')
@section('title', 'Tickets List')

@section('css')
    <style>
        .modal {
            width: 100%;
        }

        .response-success {
            width: 80%;
            text-align-last: left;
            font-size: medium;
            color: green;
        }

        .modal-close {
            position: absolute;
            right: 1rem;
            top: 1rem;
            line-height: 0;
            border-radius: 50%;
            color: white;
            font-size: 2rem;
            border: 0;
            background-image: -webkit-linear-gradient(45deg, #d73df5 0%, #8f3df5 100%);
            width: 2rem;
            height: 2rem;
        }

        .response-error {
            width: 80%;
            text-align-last: left;
            font-size: medium;
            color: red;
        }

        tr td.actions {
            width: 175px;
        }

        tr td.actions a {
            background: -webkit-linear-gradient(7deg, #ec1379 0%, #6c0092 100%);
            color: #ffffff;
            padding: 8px;
            border-radius: 5px;
        }

        .tableFixHead thead tr th {
            background: #8f3df5;
        }

        div h4 {
            text-transform: uppercase;
            background: -webkit-linear-gradient(45deg, #d73df5 0%, #8f3df5 100%);
            padding: 1rem 0.75rem 0.75rem 0.75rem;
            color: #fff;
            line-height: 1;
            margin-bottom: 1rem;
            border-radius: 15px;
        }
    </style>
@endsection

@section('style')
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.2/css/dataTables.dataTables.css">
@endsection

@section('breadcrumb-title')
    <h3>Tickets Management</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item active">Tickets Management</li>
@endsection

@section('content')
    <div class="container-fluid basic_table">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">

                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="ticketsList">
                                <thead>
                                    <tr>
                                        <th scope="col">S.No</th>
                                        <th scope="col">Contest Number</th>
                                        <th scope="col">Contest Title</th>
                                        <th scope="col">Contest Draw Date</th>
                                        <th scope="col">Tickets Purchased</th>
                                        <th scope="col">Remaining Tickets</th>
                                        <th scope="col">Status</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (count($tickets) > 0)
                                        @foreach ($tickets as $index => $ticket)
                                            @if (isset($ticket->contest))
                                                <tr>
                                                    <td scope="row">{{ ++$index }}</td>
                                                    <td>{{ $ticket->contest->contest_no }}</td>
                                                    <td>{{ $ticket->contest->title }} </span></td>
                                                    <td>{{ date('d-m-Y H:i:s', strtotime($ticket->contest->draw_date)) }}
                                                    </td>
                                                    <td>{{ $ticket->ticket_count }}</td>
                                                    <td>{{ $ticket->contest->qty - $ticket->ticket_count }}</td>
                                                    <td>
                                                        @php
                                                            $ticketStatus = \DB::table('orders_tickets')
                                                                ->where([
                                                                    'contest_id' => $ticket->contest_id,
                                                                    'ticket_status' => 'win',
                                                                ])
                                                                ->first();
                                                        @endphp
                                                        <span>
                                                            @if ($ticketStatus)
                                                                <span class="badge badge-success">Winner Declared</span>
                                                                <p><span class="badge badge-primary">Ticket
                                                                        No: {{ $ticketStatus->ticket_id }}</span></p>
                                                            @else
                                                                <span class="badge badge-danger">Yet to Declare
                                                                    Winner</span>
                                                            @endif
                                                        </span>

                                                    </td>
                                                    <td class="actions">
                                                        @if (!$ticketStatus)
                                                            <p><a href="javascript:0;" class="declare-winner"
                                                                    data-contest-no="{{ $ticket->contest->contest_no }}"
                                                                    data-contest-title="{{ $ticket->contest->title }}"
                                                                    data-contest-id="{{ $ticket->contest_id }}"
                                                                    data-ticket-id="{{ $ticket->id }}">Declare Winner</a>
                                                            </p>
                                                        @endif
                                                        <p><a href="javascript:0;" class="view-more"
                                                                data-contest-id="{{ $ticket->contest_id }}">View More</a>
                                                        </p>
                                                    </td>
                                                </tr>
                                            @endif
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Declare Winner Modal -->
        <div class="modal fade" id="declareWinnerModal" tabindex="-1" role="dialog"
            aria-labelledby="declareWinnerModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-body">
                        <div>
                            <button type="button"
                                style="line-height: 1;font-size: 1.5rem;font-family: sans-serif !important;z-index: 99999;"
                                class="close modal-close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                            <div class="row">
                                <div class="col-sm-12">
                                    <h4>Declare Winner</h4>
                                </div>
                                <div class="col-md-12">

                                    <form class="form theme-form" id="declareWinnerForm">
                                        <div class="card-body">
                                            @csrf
                                            <input type="hidden" name="ticket_id" id="winnerTicketId">
                                            <input type="hidden" name="contest_id" id="contestId">
                                            <table class="table table-striped table-bordered">
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            <p> <b>Contest Title:</b>
                                                                <span id="contestTitle"></span> &nbsp;&nbsp;&nbsp;
                                                                <b>Contest No:</b>
                                                                <span id="contestNo"></span>
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <div class="form-group">
                                                                <label for="ticketNumber">Ticket Number</label>
                                                                <input type="text" class="form-control"
                                                                    placeholder="Enter ticket number" id="ticketNumber"
                                                                    name="ticket_number" required>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>

                                            <div class="col-md-12 text-end mt-3">
                                                <div id="statusMessage"></div>
                                                <button class="btn btn-primary winner-declare-submit-btn"
                                                    type="submit">Submit</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="viewMoreModal" tabindex="-1" role="dialog" aria-labelledby="viewMoreModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-body" id="viewMoreContent">
                        <!-- Content will be loaded dynamically with jQuery -->
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        $("#ticketsList").DataTable();
        console.log('vvvvvv1');
        $(document).on('click', '.modal-close', function(e) {
            $('#declareWinnerModal').modal('hide');
            $('#viewMoreModal').modal('hide');
        });

        $('.declare-winner').on('click', function(e) {
            e.preventDefault();
            var ticketId = $(this).data('ticket-id');
            var contestId = $(this).data('contest-id');
            var contestTitle = $(this).data('contest-title'),
                contestNo = $(this).data('contest-no');


            $('#winnerTicketId').val(ticketId);
            $('#contestTitle').html(contestTitle);
            $('#contestNo').html(contestNo);
            $('#contestId').val(contestId);
            $('#declareWinnerModal').modal('show');
        });

        // Handle Declare Winner form submit
        $('#declareWinnerForm').on('submit', function(e) {
            e.preventDefault();
            var formData = $(this).serialize();
            $('.winner-declare-submit-btn').prop('disabled', true);
            $.ajax({
                url: '{{ route('admin.declare-winner') }}',
                method: 'POST',
                data: formData,
                success: function(response) {
                    if (response.status == 1) {
                        $('.winner-declare-submit-btn').prop('disabled', false);
                        $("#statusMessage").prepend(
                            '<div class="response-success">' +
                            response.message +
                            "</div>"
                        );
                        setTimeout(() => {
                            $('#declareWinnerModal').modal('hide');
                            window.location.reload();
                        }, 2000);
                    } else {

                        $("#statusMessage").prepend(
                            '<div class="response-error">' +
                            response.message +
                            "</div>"
                        );
                        $(".response-error").fadeOut(8000);
                    }
                }
            });
        });

        // Handle View More click
        $('.view-more').on('click', function(e) {
            e.preventDefault();
            var contestId = $(this).data('contest-id');
            $.ajax({
                url: '{{ route('admin.more-ticket-details') }}?contest_id=' + contestId,
                method: 'GET',
                success: function(response) {
                    $('#viewMoreContent').html(response);
                    $('#viewMoreModal').modal('show');
                }
            });
        });
    </script>
@endsection
