@extends('layouts.simple.master')
@section('title', 'Newsletter Management')

@section('style')
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.2/css/dataTables.dataTables.css">
@endsection

@section('breadcrumb-title')
    <h3>Newsletter Management</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item active">Newsletter Management</li>
@endsection

@section('content')
    <div class="container-fluid basic_table">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="transactionsList">
                                <thead>
                                    <tr>
                                        <th scope="col">ID</th>
                                        <th scope="col">email</th>
                                        <th scope="col">Subscription Status</th>
                                        <th scope="col">Created At</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (count($subscribers) > 0)
                                        @foreach ($subscribers as $index => $subscriber)
                                            <tr>
                                                <td scope="row">{{ $subscriber->id }}</td>
                                                <td>{{ $subscriber->email }}</td>
                                                <td>
                                                    @if ($subscriber->is_subscribe == 1)
                                                        <span>Active</span>
                                                    @else
                                                        <span>Active</span>
                                                    @endif

                                                </td>
                                                <td>{{ Carbon\Carbon::parse($subscriber->created_at)->format('d-m-Y H:i:s') }}
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                            {!! $subscribers->links() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        $("#transactionsList").DataTable({
            "aaSorting": [
                [0, 'desc']
            ],
            "bDestroy": true
        });
    </script>
@endsection
