@extends('layouts.simple.master')

@section('title', 'Profile Settings')

@section('css')
@endsection

@section('style')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
@endsection

@section('breadcrumb-title')
    <h3>Profile Settings</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">Dashboard</li>
    <li class="breadcrumb-item active">Profile Settings</li>
@endsection

@section('content')
    <div class="container-fluid">
        @include('layouts.alerts')

        <div class="row widget-grid">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <form class="needs-validation" novalidate="" method="POST" autocomplete="false"
                            action="{{ route('admin.update-user-profile') }}" enctype="multipart/form-data">
                            @csrf
                            <h5>Profile Settings</h5>
                            <div class="col-12">
                                <div class="mb-3 row">
                                    <label class="col-sm-3 col-form-label" for="first_name">First Name</label>
                                    <div class="col-sm-9">
                                        <div class="row">
                                            <div class="col-12 mt-2">
                                                <input class="form-control" id="first_name" type="text" required
                                                    value="{{ old('first_name', isset($user) ? $user->first_name : '') }}"
                                                    name="user[first_name]">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3 row">
                                    <label class="col-sm-3 col-form-label" for="last_name">Last Name</label>
                                    <div class="col-sm-9">
                                        <div class="row">
                                            <div class="col-12 mt-2">
                                                <input class="form-control" id="last_name" type="text" required
                                                    value="{{ old('last_name', isset($user) ? $user->last_name : '') }}"
                                                    name="user[last_name]">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3 row">
                                    <label class="col-sm-3 col-form-label" for="email">Email address</label>
                                    <div class="col-sm-9">
                                        <div class="row">
                                            <div class="col-12 mt-2">
                                                <input class="form-control" id="email" required name="user[email]"
                                                    value="{{ old('email', isset($user) ? $user->email : '') }}"
                                                    type="email" placeholder="name@example.com">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3 row">
                                    <label class="col-sm-3 col-form-label" for="phone">Phone</label>
                                    <div class="col-sm-9">
                                        <div class="row">
                                            <div class="col-12 mt-2">
                                                <input class="form-control" id="phone" name="additional[phone]"
                                                    value="{{ old('phone', isset($user) ? $user->mobile : '') }}"
                                                    type="text">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <button class="btn btn-primary custom_btn_black pull-right" type="submit">Update Profile</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="row widget-grid">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <form class="needs-validation" novalidate="" method="POST" autocomplete="false"
                            action="{{ route('admin.update-user-password') }}" enctype="multipart/form-data">
                            @csrf
                            <h5>Change Password</h5>
                            <div class="col-12">
                                <div class="mb-3 row">
                                    <label class="col-sm-3 col-form-label" for="password">Enter New Password</label>
                                    <div class="col-sm-9">
                                        <div class="row">
                                            <div class="col-12 mt-2">
                                            <input class="form-control" name="password" id="password" type="password"
                                            placeholder="Password">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3 row">
                                    <label class="col-sm-3 col-form-label" for="password">Confirm Password</label>
                                    <div class="col-sm-9">
                                        <div class="row">
                                            <div class="col-12 mt-2">
                                            <input class="form-control" name="password_confirmation" id="password_confirmation" type="password"
                                            placeholder="Confirm Password">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <button class="btn btn-primary custom_btn_black pull-right" type="submit">Update Password</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script src="{{ asset('assets/js/form-validation-custom.js') }}"></script>

    <script>
    document.addEventListener("DOMContentLoaded", function () {
        // document.querySelector("form").addEventListener("submit", function (e) {
            document.querySelector("form[action='{{ route('admin.update-user-password') }}']").addEventListener("submit", function (e) {
            let password = document.getElementById("password").value;
            let confirmPassword = document.getElementById("password_confirmation").value;

            if (!password || !confirmPassword) {
                alert("Please fill in both password fields.");
                e.preventDefault();
                return;
            }

            if (password !== confirmPassword) {
                alert("Passwords do not match!");
                e.preventDefault();
            }
        });
    });
</script>
@endsection
