@extends('layouts.simple.master')

@section('title', 'Update Question')

@section('breadcrumb-title')
    <h3>Edit Question & Answer</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">Customers</li>
    <li class="breadcrumb-item">Question & Answer</li>
    <li class="breadcrumb-item active">Edit Question</li>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Edit Question & Answer</h5>
                    </div>

                    <form class="form theme-form" method="post" enctype="multipart/form-data"
                        action="{{ route('admin.update-question-data') }}">
                        @csrf
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label" for="category">Question</label>
                                        <input type="hidden" value="{{ $question->id }}" name="question_id" />
                                        <input class="form-control" id="question" type="text" required name="question"
                                            value="{{ old('question', isset($question) ? $question->question : '') }}">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                @foreach ($question->options as $k => $option)
                                    <div class="col-sm-6">
                                        <div class="mb-3">
                                            <div class="row">
                                                <div class="col-4">
                                                    <label class="form-label" for="question">Option
                                                        {{ $k + 1 }}</label>
                                                </div>
                                                <div class="col-8">
                                                    <div class="form-check pull-right">
                                                        <input class="form-check-input" type="radio"
                                                            value="{{ $k }}" name="correct_answer"
                                                            id="correctAnswer{{ $k + 1 }}"
                                                            {{ $option->option === $question->correct_answer ? 'checked' : '' }} />
                                                        <label class="form-check-label"
                                                            for="correctAnswer{{ $k + 1 }}">
                                                            Is Correct Answer?
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <input class="form-control" id="option{{ $k + 1 }}" required
                                                type="text" name="option[{{ $option->id }}]"
                                                value="{{ old('option', isset($option) ? $option->option : '') }}" />
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>

                        <div class="card-footer text-end">
                            <button class="btn btn-primary" type="submit">Submit</button>
                            <a class="btn btn-light" href="{{ route('admin.questions-list') }}">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
