@extends('layouts.simple.master')
@section('title', 'Questions & Answer List')

@section('breadcrumb-title')
    <h3>Question & Answer</h3>
@endsection

@section('style')
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.2/css/dataTables.dataTables.css">
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">Customers</li>
    <li class="breadcrumb-item active">Question & Answer</li>
@endsection

@section('content')
    <div class="container-fluid basic_table">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    {{-- <div class="card-header">
                            <div class="pull-right">
                                <a class="btn btn-primary btn-sm" href="{{route('admin.create-question')}}" data-bs-original-title="" title=""><i class="fa fa-plus"></i> Add Question</a>
                            </div>
                        </div> --}}
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="questionTable">
                                <thead>
                                    <tr>
                                        <th scope="col">Id</th>
                                        <th scope="col">Question</th>
                                        <th scope="col">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (count($questions) > 0)
                                        @foreach ($questions as $index => $question)
                                            <tr>
                                                <th scope="row">{{ ++$index }}</th>
                                                <td>{{ $question->question }}</td>
                                                <td>
                                                    <ul class="action">
                                                        <li class="edit"> <a
                                                                href="{{ route('admin.update-question', $question->id) }}"
                                                                data-bs-original-title="" title=""><i
                                                                    class="icon-pencil-alt"></i></a>
                                                        </li>
                                                        {{-- <li class="delete"><a onclick="return confirmDelete();" href="{{route('admin.delete-question', ['questionId'=>$question->id])}}" class="btn-link"><i class="icon-trash"></i></a></li> --}}
                                                    </ul>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                            {!! $questions->links() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        $("#questionTable").DataTable();

        function confirmDelete() {
            return confirm('Are you sure you want to delete this?');
        }
    </script>
@endsection
