@extends('layouts.simple.master')

@section('title', 'Create Question')

@section('breadcrumb-title')
    <h3>Create Question & Answer</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">Customers</li>
    <li class="breadcrumb-item">Question & Answer</li>
    <li class="breadcrumb-item active">Create Question</li>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Create Question & Answer</h5>
                    </div>

                    <form class="form theme-form" method="post" enctype="multipart/form-data"
                        action="{{ route('admin.store-question') }}">
                        @csrf
                        <div class="card-body">
                            <div id="faqs_div_wrapper">
                                <div id="faqs_div">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="mb-3">
                                                <label class="form-label" for="question">Question</label>
                                                <input class="form-control" id="question" type="text" name="question"
                                                    required
                                                    value="{{ old('question', isset($questions) ? $questions->question : '') }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="mb-3">
                                                <div class="row">
                                                    <div class="col-4">
                                                        <label class="form-label" for="question">Option 1</label>
                                                    </div>
                                                    <div class="col-8">
                                                        <div class="form-check pull-right">
                                                            <input class="form-check-input" type="radio" value="0"
                                                                name="correct_answer" id="correctAnswer1">
                                                            <label class="form-check-label" for="correctAnswer1">
                                                                Is Correct Answer?
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>

                                                <input class="form-control" id="option1" type="text" name="option[]"
                                                    required
                                                    value="{{ old('question', isset($questions) ? $questions->option : '') }}">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="mb-3">
                                                <div class="row">
                                                    <div class="col-4">
                                                        <label class="form-label" for="question">Option 2</label>
                                                    </div>
                                                    <div class="col-8">
                                                        <div class="form-check pull-right">
                                                            <input class="form-check-input" type="radio" value="1"
                                                                name="correct_answer" id="correctAnswer1">
                                                            <label class="form-check-label" for="correctAnswer1">
                                                                Is Correct Answer?
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>

                                                <input class="form-control" id="option1" type="text" name="option[]"
                                                    required
                                                    value="{{ old('question', isset($questions) ? $questions->option : '') }}">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="mb-3">
                                                <div class="row">
                                                    <div class="col-4">
                                                        <label class="form-label" for="question">Option 3</label>
                                                    </div>
                                                    <div class="col-8">
                                                        <div class="form-check pull-right">
                                                            <input class="form-check-input" type="radio" value="2"
                                                                name="correct_answer" id="correctAnswer3">
                                                            <label class="form-check-label" for="correctAnswer3">
                                                                Is Correct Answer?
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>

                                                <input class="form-control" id="option1" type="text" name="option[]"
                                                    required
                                                    value="{{ old('question', isset($questions) ? $questions->option : '') }}">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="mb-3">
                                                <div class="row">
                                                    <div class="col-4">
                                                        <label class="form-label" for="question">Option 4</label>
                                                    </div>
                                                    <div class="col-8">
                                                        <div class="form-check pull-right">
                                                            <input class="form-check-input" type="radio" value="3"
                                                                name="correct_answer" id="correctAnswer4">
                                                            <label class="form-check-label" for="correctAnswer4">
                                                                Is Correct Answer?
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>

                                                <input class="form-control" id="option1" type="text"
                                                    name="option[]" required
                                                    value="{{ old('question', isset($questions) ? $questions->option : '') }}">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card-footer text-end">
                            <button class="btn btn-primary" type="submit">Submit</button>
                            <a class="btn btn-light" href="{{ route('admin.questions-list') }}">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
