@extends('layouts.simple.master')
@section('title', 'NewsList')


@section('breadcrumb-title')
    <h3>News List</h3>
@endsection
@section('css')
<style>
    .dt-search{
        float:right;
    }
    svg.w-5.h-5 {
    width: 20px !important;
    height: 20px !important;
    display: none;
}

span.relative.z-0 {
    display: flex;
    justify-content: flex-end;
    align-content: center;
    align-items: center;
    flex-wrap: nowrap;
    display: none;

}
/* .flex.justify-between.flex-1.sm\:hidden {
    display: none;
} */

 </style>
@endsection
@section('breadcrumb-items')
    <li class="breadcrumb-item">News</li>
    <li class="breadcrumb-item active">News List</li>
@endsection


@section('content')
    <div class="container-fluid basic_table">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <a class="btn btn-primary btn-sm pull-right" href="{{ route('admin.add-news') }}"
                            data-bs-original-title="" title=""><i class="fa fa-plus"></i> Add News & Insights</a>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table  table-striped table-bordered " id="NewsTable">
                                <thead class="table-dark">
                                    <tr>
                                    <!-- <th>#</th> -->
                                    <th>Image</th>
                                    <th>Title</th>
                                    <th>Category</th>
                                    <th>News Date</th>
                                    <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @forelse ($news as $index => $item)
                                    <tr>
                                    <!-- <td>{{ ($news->currentPage() - 1) * $news->perPage() + $loop->iteration }}</td> -->
                                    <td>
                                        <a target="_blank">
                                            <img src="{{ asset('assets/news/' . $item->image) }}" style="width:150px;height:150px;object-fit:cover;"  />
                                        </a></td>
                                        <td>{{ $item->title }}</td>
                                        <td>{{ $item->category->category_name ?? 'Uncategorized' }}</td>
                                        <td>{{ \Carbon\Carbon::parse($item->news_date)->format('d M Y') }}</td>
                                        <td>
                                            <ul class="action">
                                                <li class="edit"><a href="{{ route('admin.update-news', $item->id) }}"><i class="icon-pencil-alt"></i></a></li>
                                                <li class="delete"><a onclick="return confirmDelete();"
                                                                            href="{{ route('admin.delete-news',  $item->id) }}"
                                                                            data-bs-original-title="" title=""><i
                                                                                class="icon-trash"></i></a></li>
                                                </ul>
                                            
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3" class="text-center">No news found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                            </table>  
                            <!-- {!! $news->links() !!} -->
                            <div class="flex justify-center mt-4">
                                {!! $news->links() !!}
                            </div>
                         </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        $("#NewsTable").DataTable();

        function confirmDelete() {
            return confirm('Are you sure you want to delete this News Item?');
        }
    </script>
  
     
@endsection
