@extends('layouts.simple.master')

@if (isset($user))
@section('title', 'Update Customer')
@else
@section('title', 'Create News')
@endif

@section('css')
    <style>
        .avatar-preview>div {
            width: 100%;
            height: 100%;
            border-radius: 50%;
            background-size: cover;
            background-repeat: no-repeat;
            background-position: top;
        }

        .form-group {
            margin-bottom: 20px; /* Increased spacing */
        }

        .card {
            padding: 20px;
        }

        .ck-editor__editable {
            min-height: 250px; /* Increased height for better usability */
        }

        .image-inline.ck-widget {
            position: relative; /* Ensures absolute positioning works */
            display: inline-block;
        }

.remove-image-btn {
    position: absolute;
    top: 5px;
    right: 5px;
    background-color: yellow;
    color: red;
    border: none;
    padding: 5px 10px;
    font-size: 12px;
    font-weight: bold;
    cursor: pointer;
    border-radius: 5px;
    z-index: 9999;
    opacity: 0.8;
    transition: opacity 0.2s ease-in-out;
}

.remove-image-btn:hover {
    opacity: 1;
}
.text-start {
            margin-left: -25px !important;
}


    </style>
@endsection

@section('breadcrumb-title')
        <h3>Edit News</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">News</li>
    <li class="breadcrumb-item active">Edit News</li>
   
@endsection

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-10">
                <div class="card">
                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="text-start">
                        <button type="button" class="btn btn-sm" onclick="history.back()">
                        <i class="icon-arrow-left"></i>
                        </button>
                    </div>

                    <div class="card-body">
                    <form id="AddForm" name="AddForm" action="{{ route('admin.update-newsdata', $news->id) }}" method="post"
                    enctype="multipart/form-data">

                            <input type="hidden" name="_token" id="_token" value="{{ csrf_token() }}">

                            <div class="form-group">
                                <label class="form-label required">Category</label>
                                <select name="category_id" id="category_id" class="form-control" required>
                                            <option value="">Select Category</option>
                                            @foreach($categories as $category)
                                                <option value="{{ $category->id }}" {{ $news->category_id == $category->id ? 'selected' : '' }}>
                                                    {{ $category->category_name }}
                                                </option>
                                            @endforeach
                                </select>
                            </div>

                            <div class="form-group">
                                <label class="form-label required" for="title">News Title</label>
                                <input type="text" class="form-control" name="title" id="title" 
                                 value= "{{ old('title', isset($news) ? $news->title : '') }}" placeholder="Enter News Title">

                            </div>

                            <div class="form-group">
                                <label class="form-label required" for="image">News Image</label>
                                <input type="file" class="form-control" name="image" id="image">
                                <small class="text-muted">Only JPG, JPEG, GIF files allowed. Max size: 2MB.</small>
                            </div>

                            <div class="form-group text-center">
                            <?php
                            
                                //  $Image = 'http://localhost/dovehouse-Capital/public/assets/news/' . $news->image;
                                
                                  $Image = 'https://caferoute66.com/dovehouse/public/assets/news/'.$news->image;

                                ?>
                                    <img id="imagePreview" src='{{ $Image }}' width="100" height="80" class="img-thumbnail">
                            </div>

                            <div class="form-group">
                                <label class="form-label required" for="short_description">News Short Description</label>
                                <textarea class="form-control" rows="5" name="short_description" id="short_description" placeholder="Enter short Description" style="visibility: show !important;">{{ $news->short_description }}</textarea>
                            </div>

                            <div class="form-group">
                                <label class="form-label required" for="long_description">News Long Description</label>
                                <textarea id="long_description" name="long_description" class="form-control" placeholder="Enter News Description">{{ $news->long_description }}</textarea>
                                <input type="hidden" name="removed_images" id="removed_images" value="[]">

                            </div>

                            <div class="form-group">
                                <label class="form-label required" for="news_date">News Date</label>
                                <input class="form-control" type="date" id="news_date" name="news_date" value="{{ old('news_date', \Carbon\Carbon::parse($news->news_date)->format('Y-m-d')) }}" placeholder="Select date">
                                </div>

                            <div class="form-group text-center">
                                <button type="submit" id="SubmitBtn" class="btn btn-primary w-100">Update News & Insights</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
<script src="https://cdn.ckeditor.com/ckeditor5/36.0.1/classic/ckeditor.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>


<script>
document.addEventListener("DOMContentLoaded", function () {
    ClassicEditor
        .create(document.querySelector('#long_description'), {
            toolbar: ['bold', 'italic', 'bulletedList', 'numberedList', 'imageUpload'],
            ckfinder: {
                uploadUrl: "{{ route('admin.ckeditor.upload') . '?_token=' . csrf_token() }}",
            }
        })
        .then(editor => {
            window.editor = editor;
            let removedImages = [];

            // Function to collect all images inside the editor
            function getEditorImages() {
                return Array.from(document.querySelectorAll(".ck-content img")).map(img => img.getAttribute("src"));
            }

            // Initial images in editor
            let previousImages = getEditorImages();

            // Observe changes in editor content
            const observer = new MutationObserver(() => {
                let currentImages = getEditorImages();

                // Find removed images
                previousImages.forEach(imgSrc => {
                    if (!currentImages.includes(imgSrc) && imgSrc) {
                        removedImages.push(imgSrc); // Store deleted image path
                    }
                });

                previousImages = currentImages; // Update previous images
                $("#removed_images").val(JSON.stringify(removedImages)); // Store in hidden input
            });

            observer.observe(document.querySelector(".ck-content"), { childList: true, subtree: true });
        })
        .catch(error => console.error('CKEditor Error:', error));
});

</script>

<script>
        $(document).ready(function () {
            $("#image").change(function () {
                var input = this;
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        $('#imagePreview').attr('src', e.target.result).show();
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            });
        });
    </script>
<script>
    $(document).ready(function () {

    function validateField(field, condition, message) {
    let errorSpan = field.next(".text-danger");

    if (condition) {
        errorSpan.remove(); // Remove error if valid
    } else {
        if (errorSpan.length === 0) {
            field.after(`<span class="text-danger">${message}</span>`);
        }
    }
}

$("#SubmitBtn").click(function (event) {
    event.preventDefault();
    let isValid = true;
    $(".text-danger").remove();

    let category = $("#category_id");
    if (category.val() === "") {
        validateField(category, false, "Category is required.");
        isValid = false;
    } else {
        validateField(category, true, "");
    }

    let title = $("#title");
    if (title.val().trim().length < 5) {
        validateField(title, false, "News Title must be at least 5 characters.");
        isValid = false;
    } else {
        validateField(title, true, "");
    }

    // Modify image validation: Only check if a new file is selected
    let image = $("#image");
    let imageVal = image.val();
    let validExtensions = ["jpg", "jpeg", "gif"];
    let fileExtension = imageVal.split('.').pop().toLowerCase();

    if (imageVal !== "") { // Only validate if a new file is selected
        if (!validExtensions.includes(fileExtension)) {
            validateField(image, false, "Invalid image format. Only JPG, JPEG, and GIF allowed.");
            isValid = false;
        } else {
            validateField(image, true, "");
        }
    } else {
        validateField(image, true, ""); // No error if no file is selected
    }

    let shortDesc = $("#short_description");
    if (shortDesc.val().trim().length < 20) {
        validateField(shortDesc, false, "Short Description must be at least 20 characters.");
        isValid = false;
    } else {
        validateField(shortDesc, true, "");
    }

    let longDesc = window.editor.getData().trim();
    let longDescField = $("#long_description");
    if (longDesc.length < 50) {
        validateField(longDescField, false, "Long Description must be at least 50 characters.");
        isValid = false;
    } else {
        validateField(longDescField, true, "");
    }

    let newsDate = $("#news_date");
    if (newsDate.val() === "") {
        validateField(newsDate, false, "News Date is required.");
        isValid = false;
    } else {
        validateField(newsDate, true, "");
    }

    if (isValid) {
        $("#AddForm").submit();
    }
});

});

// Remove errors when the user corrects input
$("#category_id, #title, #short_description, #news_date").on("input change", function () {
    validateField($(this), true, "");
});

$("#image").change(function () {
    let imageVal = $(this).val();
    let validExtensions = ["jpg", "jpeg", "gif"];
    let fileExtension = imageVal.split('.').pop().toLowerCase();

    if (imageVal !== "" && validExtensions.includes(fileExtension)) {
        validateField($(this), true, "");
    }
});

window.editor.model.document.on('change:data', () => {
    let longDesc = window.editor.getData().trim();
    let longDescField = $("#long_description");

    if (longDesc.length >= 50) {
        validateField(longDescField, true, "");
    }
});


</script>