<div class="row mb-3">

    <div class="col-sm-12">
        <h4>Customer Support Section</h4>
    </div>

    <div class="col-sm-12">
        <div class="mb-3">
            <label class="form-label" for="supportTitle">Title</label>
            <input class="form-control" id="supportTitle" type="text" value="{{$support->title ?? ''}}" required name="support[title]" />
        </div>
    </div>

    <div class="col-sm-12">
        <div class="mb-3">
            <label class="form-label" for="supportSubTitle">Sub Title</label>
            <input class="form-control" id="supportSubTitle" type="text" value="{{$support->sub_title ?? ''}}" required name="support[sub_title]" />
        </div>
    </div>

    <div class="col-sm-12">
        <div class="mb-3">
            <label class="form-label" for="supportDescription">Description</label>
            <textarea class="form-control" id="supportDescription" required rows="2" name="support[description]">{{$support->description ?? ''}}</textarea>
        </div>
    </div>

    <div class="col-sm-12">
        <h6>Support team.</h6>
        <div class="row mb-3">
            <div class="mb-1 col-6">
                <label class="form-label" for="supportTeamTitle">Title</label>
                <input class="form-control" id="supportTeamTitle" type="text" required name="support[team][title]" value="{{$supportTeam->title ?? ''}}" />
            </div>

            <div class="mb-1 col-6">
                <label class="form-label" for="supportTeamSubTitle">Sub Title</label>
                <input class="form-control" id="supportTeamSubTitle" type="text" required name="support[team][sub_title]" value="{{$supportTeam->sub_title ?? ''}}" />
            </div>


            @if(!isset($supportTeam->image))
                <div class="mb-1">
                    <label class="form-label" for="supportTeamImage">Image</label>
                    <input class="form-control" id="supportTeamImage" type="file" required name="support[team][image]" accept=".png, .jpg, .jpeg, .svg">
                </div>
            @else
                <div class="mb-1">
                    <div class="row mt-3 d-flex align-items-center">
                        <div class="{{(!empty($supportTeam->image) && Storage::exists($supportTeam->image))?'col-10':'col-12' }}">

                            <label class="form-label" for="supportTeamImage">Image <span class="text-red">{{(!empty($supportTeam->image) && Storage::exists($supportTeam->image))?'':'*' }}</span></label>

                            <input class="form-control" id="supportTeamImage" type="file" accept=".png, .jpg, .jpeg, .svg" name="support[team][image]" {{(!empty($supportTeam->image) && Storage::exists($supportTeam->image))?:'required' }}  />
                        </div>
                        @if(!empty($supportTeam->image) && Storage::exists($supportTeam->image))
                            <div class="col-2 p-0">
                                <a href="{{asset(Storage::url($supportTeam->image))}}" target="_blank">
                                    <img src="{{asset(Storage::url($supportTeam->image))}}" style="width:100px;" alt="{{$supportTeam->title}}" />
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            @endif

            <div class="col-sm-12">
                @php
                    $supportTeamContact = !empty($supportTeam->value)? json_decode($supportTeam->value) : null;
                @endphp
                <div class="row">
                    <div class="col-6 mb-1">
                        <label class="form-label" for="supportMobile">Mobile</label>
                        <input class="form-control" id="supportMobile" type="text" required name="support[team][contact][mobile]" value="{{$supportTeamContact->mobile ?? ''}}" />
                    </div>

                    <div class="col-6 mb-1">
                        <label class="form-label" for="supportEmail">Email</label>
                        <input class="form-control" id="supportEmail" type="email" required name="support[team][contact][email]" value="{{$supportTeamContact->email ?? ''}}" />
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-sm-12">
        <h6>FAQs & Help.</h6>
        <div class="row mb-3">
            <div class="mb-1 col-6">
                <label class="form-label" for="supportRFQTitle">Title</label>
                <input class="form-control" id="supportRFQTitle" type="text" required name="support[rfq][title]" value="{{$supportFaqs->title ?? ''}}" />
            </div>

            <div class="mb-1 col-6">
                <label class="form-label" for="supportRFQSubTitle">Sub Title</label>
                <input class="form-control" id="supportRFQSubTitle" type="text" required name="support[rfq][sub_title]" value="{{$supportFaqs->sub_title ?? ''}}" />
            </div>

            @if(!isset($supportFaqs->image))
                <div class="mb-1">
                    <label class="form-label" for="supportRFQImage">Image</label>
                    <input class="form-control" id="supportRFQImage" type="file" required name="support[rfq][image]" accept=".png, .jpg, .jpeg, .svg">
                </div>
            @else
                <div class="mb-1">
                    <div class="row mt-3 d-flex align-items-center">
                        <div class="{{(!empty($supportFaqs->image) && Storage::exists($supportFaqs->image))?'col-10':'col-12' }}">
                            <label class="form-label" for="supportRFQImage">Image <span class="text-red">{{(!empty($supportFaqs->image) && Storage::exists($supportFaqs->image))?'':'*' }}</span></label>

                            <input class="form-control" id="supportRFQImage" type="file" accept=".png, .jpg, .jpeg, .svg" name="support[rfq][image]" {{(!empty($supportFaqs->image) && Storage::exists($supportFaqs->image))?:'required' }}  />
                        </div>
                        @if(!empty($supportFaqs->image) && Storage::exists($supportFaqs->image))
                            <div class="col-2 p-0">
                                <a href="{{asset(Storage::url($supportFaqs->image))}}" target="_blank">
                                    <img src="{{asset(Storage::url($supportFaqs->image))}}" style="width:100px;" alt="{{$supportFaqs->title}}" />
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            @endif

            <div class="col-sm-12">
                @php
                    $supportFaq = !empty($supportFaqs->value)? json_decode($supportFaqs->value) : null;
                @endphp
                <div class="row">
                    <div class="col-6 mb-3">
                        <label class="form-label" for="supportRFQButton">Button Title</label>
                        <input class="form-control" id="supportRFQButton" type="text" required name="support[rfq][button][title]" value="{{$supportFaq->title ?? ''}}" />
                    </div>

                    <div class="col-6 mb-3">
                        <label class="form-label" for="supportButtonURL">Button Link</label>
                        <input class="form-control" id="supportButtonURL" type="url" required name="support[rfq][button][link]" value="{{$supportFaq->link ?? ''}}"/>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
