<div class="row mb-3">

    <div class="col-sm-12">
        <h4>How To Play Section</h4>
    </div>

    <div class="col-sm-12">
        <div class="mb-3">
            <label class="form-label" for="howToPlayTitle">Title</label>
            <input class="form-control" id="howToPlayTitle" value="{{ $howToPlay->title ?? '' }}" type="text" required
                name="howToPlay[title]" />
        </div>
    </div>

    <div class="col-sm-12">
        <div class="mb-3">
            <label class="form-label" for="howToPlaySubTitle">Sub Title</label>
            <input class="form-control" id="howToPlaySubTitle" value="{{ $howToPlay->sub_title ?? '' }}" type="text"
                required name="howToPlay[sub_title]" />
        </div>
    </div>

    <div class="col-sm-12">
        <div class="mb-3">
            <label class="form-label" for="howToPlayDescription">Description</label>
            <textarea class="form-control" id="howToPlayDescription" required rows="3" name="howToPlay[description]">{{ $howToPlay->description ?? '' }}</textarea>
        </div>
    </div>

    <div class="col-sm-12">

        <h4>Follow this 5 easy steps.</h4>

        @for ($i = 1; $i <= 5; $i++)
            @php
                $htpData = $howToPlay->moreRelatedData[$i - 1] ?? [];
            @endphp
            <div class="row mb-3">
                <div class="mb-1 col-6">
                    <label class="form-label" for="howToPlayTitle{{ $i }}">Title</label>
                    <input class="form-control" id="howToPlayTitle{{ $i }}" type="text" required
                        name="howToPlay[steps][{{ $i }}][title]" value="{{ $htpData->title ?? '' }}">
                </div>

                <div class="mb-1 col-6">
                    <label class="form-label" for="howToPlaySubTitle{{ $i }}">Sub Title</label>
                    <input class="form-control" id="howToPlaySubTitle{{ $i }}" type="text" required
                        name="howToPlay[steps][{{ $i }}][sub_title]"
                        value="{{ $htpData->sub_title ?? '' }}">
                </div>

                @if (!isset($htpData->image))
                    <div class="mb-1">
                        <label class="form-label" for="howToPlayImage{{ $i }}">Image</label>
                        <input class="form-control" id="howToPlayImage{{ $i }}" type="file" required
                            name="howToPlay[steps][{{ $i }}][image]" accept=".png, .jpg, .jpeg, .svg">
                    </div>
                @else
                    <div class="mb-1">
                        <div class="row mt-3 d-flex align-items-center">
                            <div
                                class="{{ !empty($htpData->image) && Storage::exists($htpData->image) ? 'col-10' : 'col-12' }}">
                                <label class="form-label" for="howToPlayImage{{ $i }}">Image <span
                                        class="text-red">{{ !empty($htpData->image) && Storage::exists($htpData->image) ? '' : '*' }}</span></label>

                                <input class="form-control" id="howToPlayImage{{ $i }}" type="file"
                                    accept=".png, .jpg, .jpeg, .svg"
                                    name="howToPlay[steps][{{ $i }}][image]"
                                    {{ !empty($htpData->image) && Storage::exists($htpData->image) ?: 'required' }} />
                            </div>
                            @if (!empty($htpData->image) && Storage::exists($htpData->image))
                                <div class="col-2 p-0" style="background: gray;">
                                    <a href="{{ asset(Storage::url($htpData->image)) }}" target="_blank">
                                        <img src="{{ asset(Storage::url($htpData->image)) }}" style="width:100px;"
                                            alt="{{ $htpData->title }}" />
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                @endif
            </div>
        @endfor
    </div>
</div>
