<div class="row mb-3">

    <div class="col-sm-12">
        <h4>Feature Section</h4>
    </div>

    <div class="col-sm-12">
        <div class="mb-3">
            <label class="form-label" for="featureTitle">Title</label>
            <input class="form-control" id="featureTitle" type="text" value="{{$feature->title ?? ''}}" required name="feature[title]" />
        </div>
    </div>

    <div class="col-sm-12">
        <div class="mb-3">
            <label class="form-label" for="featureSubtitle">Sub Title</label>
            <input class="form-control" id="featureSubtitle" type="text" value="{{$feature->sub_title ?? ''}}" required name="feature[sub_title]" />
        </div>
    </div>

    <div class="col-sm-12">
        <div class="mb-3">
            <label class="form-label" for="featureDescription">Description</label>
            <textarea class="form-control" id="featureDescription" required rows="3" name="feature[description]">{{$feature->description ?? ''}}</textarea>
        </div>
    </div>

    <div class="col-12 mb-3">
        <label class="form-label" for="featureButtonURL">Show All Features Link</label>
        <input class="form-control" id="featureButtonURL" type="url" required name="feature[buttonURL]" value="{{$feature->value ?? ''}}">
    </div>

    <div class="col-sm-12">

        <h6>Feature Steps.</h6>
        @for ($i=1; $i <= 4; $i++)
            @php
                $fsData = $feature->moreRelatedData[$i - 1] ?? [];
            @endphp
            <div class="row mb-3">
                <div class="mb-1 col-6">
                    <label class="form-label" for="featureStepTitle{{$i}}">Title</label>
                    <input class="form-control" id="featureStepTitle{{$i}}" value="{{$fsData->title ?? ''}}" type="text" required name="feature[steps][{{$i}}][title]" />
                </div>

                <div class="mb-1 col-6">
                    <label class="form-label" for="featureStepSubTitle{{$i}}">Sub Title</label>
                    <input class="form-control" id="featureStepSubTitle{{$i}}" value="{{$fsData->sub_title ?? ''}}" type="text" required name="feature[steps][{{$i}}][sub_title]" />
                </div>

                @if(!isset($fsData->image))
                    <div class="mb-1">
                        <label class="form-label" for="featureStepImage{{$i}}">Image</label>
                        <input class="form-control" id="featureStepImage{{$i}}" type="file" required name="feature[steps][{{$i}}][image]" accept=".png, .jpg, .jpeg, .svg" />
                    </div>
                @else
                    <div class="mb-1">
                        <div class="row d-flex align-items-center mt-3">
                            <div class="{{(!empty($fsData->image) && Storage::exists($fsData->image))?'col-10':'col-12' }}">
                                <label class="form-label" for="featureStepImage{{$i}}">Image <span class="text-red">{{(!empty($fsData->image) && Storage::exists($fsData->image))?'':'*' }}</span></label>

                                <input class="form-control" id="featureStepImage{{$i}}" type="file" accept=".png, .jpg, .jpeg, .svg" name="feature[steps][{{$i}}][image]" {{(!empty($fsData->image) && Storage::exists($fsData->image))?:'required' }}  />
                            </div>
                            @if(!empty($fsData->image) && Storage::exists($fsData->image))
                                <div class="col-2 p-0">
                                    <a href="{{asset(Storage::url($fsData->image))}}" target="_blank">
                                        <img src="{{asset(Storage::url($fsData->image))}}" style="width:100px;" alt="{{$fsData->title}}" />
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                @endif
            </div>
        @endfor
    </div>
</div>
