<div class="row mb-3">

    <div class="col-sm-12">
        <h4>Banner Section</h4>
    </div>

    <div class="col-sm-12">
        <div class="mb-3">
            <label class="form-label" for="bannerTitle">Title</label>
            <input class="form-control" id="bannerTitle" value="{{$banner->title ?? ''}}" type="text" required name="banner[title]" />
        </div>
    </div>

    <div class="col-sm-12">
        <div class="mb-3">
            <label class="form-label" for="bannerSubTitle">Sub Title</label>
            <input class="form-control" id="bannerSubTitle" value="{{$banner->sub_title ?? ''}}" type="text" required name="banner[sub_title]" />
        </div>
    </div>

    <div class="col-sm-12">
        <div class="mb-3">
            <label class="form-label" for="bannerDescription">Description</label>
            <textarea class="form-control" id="bannerDescription" required rows="3" name="banner[description]">{{$banner->description ?? ''}}</textarea>
        </div>
    </div>

    @if(!isset($banner->image))
        <div class="col-sm-12">
            <div class="mb-3">
                <label class="form-label" for="bannerImage">Image</label>
                <input class="form-control" id="bannerImage" type="file" required name="banner[image]" accept=".png, .jpg, .jpeg, .svg">
            </div>
        </div>
    @else
        <div class="col-md-12">
            <div class="row mb-3 d-flex align-items-center">
                <div class="{{(!empty($banner->image) && Storage::exists($banner->image))?'col-10':'col-12' }}">
                    <label class="form-label" for="bannerImage">Image <span class="text-red">{{(!empty($banner->image) && Storage::exists($banner->image))?'':'*' }}</span></label>

                    <input class="form-control" type="file" accept=".png, .jpg, .jpeg, .svg" name="banner[image]" {{(!empty($banner->image) && Storage::exists($banner->image))?:'required' }}  />
                </div>
                @if(!empty($banner->image) && Storage::exists($banner->image))
                    <div class="col-2 p-0">
                        <a href="{{asset(Storage::url($banner->image))}}" target="_blank">
                            <img src="{{asset(Storage::url($banner->image))}}" style="width:100px;" alt="{{$banner->title}}" />
                        </a>
                    </div>
                @endif
            </div>
        </div>
    @endif


    <div class="col-sm-12">
        <div class="row">
            <div class="col-6 mb-3">
                <label class="form-label" for="bannerButtonTitle">Button Title</label>
                <input class="form-control" id="bannerButtonTitle" type="text" required name="banner[buttonTitle]" value="{{$banner->key ?? ''}}">
            </div>

            <div class="col-6 mb-3">
                <label class="form-label" for="bannerButtonURL">Button Link</label>
                <input class="form-control" id="bannerButtonURL" type="url" required name="banner[buttonURL]" value="{{$banner->value ?? ''}}">
            </div>
        </div>
    </div>
</div>
