@extends('layouts.simple.master')

@section('title', 'Homepage')

@section('css')
    <style>
        .footer-copyright p {
            color: #ff1386 !important;
        }

        @media (min-width: 992px) {
            .footer {
                width: auto;
                display: inline;
                position: absolute;
                background: none;
                left: calc(50% - 265px);
                box-shadow: none;
            }
        }

        @media (max-width: 991px) {
            .options_sticky {
                width: 100%;
                left: 0;
            }

            .options_sticky .row.text-end {
                text-align: center !important;
            }
        }
    </style>
@endsection

@section('style')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
@endsection

@section('breadcrumb-title')
    <h3>Homepage</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">CMS</li>
    <li class="breadcrumb-item active">Homepage</li>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <form class="form theme-form" enctype="multipart/form-data" method="post"
                    action="{{ route('admin.homepage.store') }}">
                    @csrf
                    <div class="card">
                        <div class="card-header">
                            <div class="row text-end">
                                <div class="col-12">
                                    <button class="btn btn-primary" type="submit">Save</button>
                                    <input class="btn btn-light" type="reset" value="Cancel">
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            @include('admin.homepage.sessions.banner')
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">
                            @include('admin.homepage.sessions.how_play')
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">
                            @include('admin.homepage.sessions.contest')
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">
                            @include('admin.homepage.sessions.feature')
                        </div>
                    </div>

                    <div class="card" style="margin-bottom: 100px !important;">
                        <div class="card-body">
                            @include('admin.homepage.sessions.support')
                        </div>
                    </div>

                    <div class="card options_sticky">
                        <div class="card-body py-3">
                            <div class="row text-end">
                                <div class="col-12">
                                    <button class="btn btn-primary" type="submit">Save</button>
                                    <a class="btn btn-light" href="">Cancel</a>
                                </div>
                            </div>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>
@endsection

@section('script')
@endsection
