@extends('layouts.simple.master')

@section('title', 'Update FAQs')

@section('breadcrumb-title')
    <h3>Update FAQs</h3>
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">Update FAQs</li>
@endsection

@section('script')
    <script>
        $(document).ready(function() {

            $(document).on('click', '.delete-faq', function() {
                const faqId = $(this).data('id');
                if (confirm('Do you want to FAQ?')) {
                    $.ajax({
                        type: "DELETE",
                        data: {
                            _token: '{{ csrf_token() }}',
                            'faqId': faqId
                        },
                        url: "{{ route('admin.faqs.delete-faq') }}",
                        success: function(response) {
                            console.log(response);
                        }
                    });
                }
            });

            var faqCounter = 1;

            $(document).on('click', '.addMoreFaqs', function() {
                const neweditorId = "updateck" + faqCounter;
                console.log(neweditorId, 'neweditorId');
                var newItem = `
				<div class="faq-item">
					<div class="row">
						<div class="col-sm-10">
							<div class="mb-3">
								<label class="form-label" for="question">Question</label>
								<input type="hidden" name="faqId[]" />
								<input class="form-control" type="text" name="question[]">
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="mb-3">
								<label class="form-label" for="answer">Answer</label>
								<textarea class="form-control btn-square ckeditor" id="` + neweditorId + `" name="answer[]" rows="3" spellcheck="true"></textarea>
							</div>
						</div>
					</div>
				</div>`;
                $('#faqs_div').append(newItem);
                faqCounter++;
                // Initialize CKEditor for the new textarea
                CKEDITOR.replace(neweditorId);

            });
        });
    </script>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">

                <form class="form theme-form" method="post" enctype="multipart/form-data"
                    action="{{ route('admin.faqs.update-faq') }}">
                    <div class="card" style="margin-bottom: 100px !important;">
                        <div class="card-header">
                            <h5>Update FAQs</h5>
                        </div>
                        @csrf
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label" for="category">Category Type</label>
                                        @php
                                            $faqCategories = DB::table('faq_categories')->get();
                                        @endphp
                                        <select class="form-select digits" name="category" id="category"
                                            fdprocessedid="3paag">
                                            <option>Select Category Type</option>
                                            @foreach ($faqCategories as $category)
                                                <option value="{{ $category->id }}"
                                                    {{ $faqCategory->id == $category->id ? 'selected' : '' }}>
                                                    {{ $category->title }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                            </div>


                            <div id="faqs_div_wrapper">
                                <div id="faqs_div">
                                    @if ($faqCategory?->faqs)
                                        @foreach ($faqCategory->faqs as $k => $faq)
                                            <div class="row">
                                                <div class="col-sm-10">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="question">Question</label>
                                                        <input type="hidden" name="faqId[]" value="{{ $faq->id }}" />
                                                        <input class="form-control" id="question" type="text"
                                                            name="question[]"
                                                            value="{{ old('question', isset($faq) ? $faq->question : '') }}">
                                                    </div>
                                                </div>
                                                <div class="col-sm-2">
                                                    <button type="button" class="btn btn-danger delete-faq"
                                                        data-id="{{ $faq->id }}">Delete</button>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="answer">Answer</label>
                                                        <textarea class="form-control btn-square texteditor" name="answer[]" id="update_editor{{ $k + 2 }}"
                                                            rows="3" spellcheck="true">{{ $faq->answer }}</textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @else
                                        <div class="row">
                                            <div class="col-sm-10">
                                                <div class="mb-3">
                                                    <label class="form-label" for="question">Question</label>
                                                    <input class="form-control" id="question" type="text"
                                                        name="question[]"
                                                        value="{{ old('question', isset($faq) ? $faq->question : '') }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="mb-3">
                                                    <label class="form-label" for="answer">Answer</label>
                                                    <textarea class="form-control btn-square" name="answer[]" id="editor1" rows="3" spellcheck="true">{{ $faq->answer }}</textarea>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>



                            <div class="card-header">
                                <a class="btn btn-primary btn-sm addMoreFaqs"><i class="fa fa-plus"></i> Add More</a>
                            </div>
                        </div>

                    </div>
                    <div class="card options_sticky">
                        <div class="card-body py-3">
                            <div class="row text-end">
                                <div class="col-12">
                                    <button class="btn btn-primary" type="submit">Save</button>
                                    <a class="btn btn-light" href="">Cancel</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>
@endsection


@section('css')
    <style>
        .footer-copyright p {
            color: #ff1386 !important;
        }

        @media (min-width: 992px) {
            .footer {
                width: auto;
                display: inline;
                position: absolute;
                background: none;
                left: calc(50% - 265px);
                box-shadow: none;
            }
        }

        @media (max-width: 991px) {
            .options_sticky {
                width: 100%;
                left: 0;
            }

            .options_sticky .row.text-end {
                text-align: center !important;
            }
        }
    </style>
@endsection
