@extends('layouts.simple.master')
@section('title', 'FAQs List')

@section('breadcrumb-title')
<h3>FAQs</h3>
@endsection

@section('style')
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.2/css/dataTables.dataTables.css">
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item active">FAQs</li>
@endsection

@section('content')
<div class="container-fluid basic_table">
  <div class="row">
    <div class="col-sm-12">
      <div class="card">
        <div class="card-header">
          <div class="pull-right">
              <a class="btn btn-primary btn-sm"   href="{{route('admin.faqs.create-faq')}}" data-bs-original-title="" title=""><i class="fa fa-plus"></i> Add FAQ</a>
              <a class="btn btn-primary btn-sm"   href="{{route('admin.faqs.faq-categories')}}" data-bs-original-title="" title=""><i class="fa fa-plus"></i>FAQ Categories</a>
          </div>
        </div>
        <div class="card-body">
          <div class="table-responsive">
            <table class="table" id="faqsTable">
              <thead>
                <tr>
                  <th scope="col">Id</th>
                  <th scope="col">Category</th>
                  <th scope="col">Actions</th>
                </tr>
              </thead>
              <tbody>
                @if(count($faqs) > 0)
                  @foreach($faqs as $index=>$faq)
                    <tr>
                      <th scope="row">{{++$index;}}</th>
                      <td>{{$faq->title}}</td>
                      <td>
                        <ul class="action">
                          <li class="edit"> <a href="{{route('admin.faqs.update-faqs', $faq->id)}}" data-bs-original-title="" title=""><i class="icon-pencil-alt"></i></a>
                          </li>
                        </ul>
                      </td>
                    </tr>
                  @endforeach
                @endif
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection

@section('script')
  <script>
    $("#faqsTable").DataTable({"aaSorting": [[0,'asc']], "bDestroy": true});
  </script>
@endsection