@extends('layouts.simple.master')

@section('title', 'Create FAQs')

@section('breadcrumb-title')
@endsection

@section('breadcrumb-items')
    <li class="breadcrumb-item">Create FAQs</li>
@endsection

@section('script')
<script>
	$(document).ready(function() {
    	var faqCounter = 1;
		$('.addMoreFaqs').click(function() {
			const neweditorId = "newck"+faqCounter;
			var newItem = `
				<div class="faq-item">
					<div class="row">
						<div class="col-sm-10">
							<div class="mb-3">
								<label class="form-label" for="question">Question</label>
								<input class="form-control" type="text" name="question[]">
							</div>
						</div>
						<div class="col-sm-2">
                            <button type="button" class="btn btn-danger delete-faq">Delete</button>
                        </div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="mb-3">
								<label class="form-label" for="answer">Answer</label>
								<textarea class="form-control btn-square ckeditor" id="`+neweditorId+`" name="answer[]" rows="3" spellcheck="true"></textarea>
							</div>
						</div>
					</div>
				</div>`;
			$('#faqs_div').append(newItem);
			faqCounter++;
			// Initialize CKEditor for the new textarea
			CKEDITOR.replace(neweditorId);
		});

		// Function to delete FAQ item
		$(document).on('click', '.delete-faq', function() {
			$(this).closest('.faq-item').remove();
		});
	});


</script>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
		<div class="col-sm-12">
			<div class="card">
				<div class="card-header">
					<h5>create FAQs</h5>
				</div>
				
				<form class="form theme-form" method="post" enctype="multipart/form-data" action="{{route('admin.faqs.store-faqs')}}">
				@csrf
					<div class="card-body">
						<div class="row">
							<div class="col-sm-6">
								<div class="mb-3">
									<label class="form-label" for="category">Category Type</label>
									@php
										$faqCategories = DB::table('faq_categories')->get();
									@endphp
									<select class="form-select digits" name="category" id="category" fdprocessedid="3paag">
										<option>Select Category Type</option>
										@foreach($faqCategories as $category)
											<option value="{{$category->id}}">{{$category->title}}</option>
										@endforeach
									</select>
								</div>
							</div>
							
						</div>	
						<div id="faqs_div_wrapper">
							<div id="faqs_div">
								<div class="row">
									<div class="col-sm-10">
										<div class="mb-3">
											<label class="form-label" for="question">Question</label>
											<input class="form-control" id="question" type="text" name="question[]"  value="{{ old('question', (isset($faqs) ? $faqs->question : '')) }}">
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-sm-12">
										<div class="mb-3">
											<label class="form-label" for="answer">Answer</label>
											<textarea class="form-control btn-square" name="answer[]" id="editor1" rows="3" spellcheck="true"></textarea>	
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="card-header">
                    		<a class="btn btn-primary btn-sm addMoreFaqs"><i class="fa fa-plus"></i> Add More</a>
						</div>
					</div>
				
					<div class="card-footer text-end">
						<button class="btn btn-primary" type="submit">Submit</button>
						<input class="btn btn-light" type="reset" value="Cancel">
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
@endsection

@section('scripts')
    <script src="{{asset('assets/js/editor/ckeditor/ckeditor.custom.js')}}"></script>
@endsection
