@extends('layouts.simple.master')

@section('title', 'FAQ Categories List')

@section('css')
    
@endsection

@section('style')
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.2/css/dataTables.dataTables.css">
@endsection

@section('breadcrumb-title')
<h3>FAQ Categories List</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">FAQ's</li>
    <li class="breadcrumb-item active">FAQ Categories List</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
	  <div class="col-sm-12">
      <div class="card">
          <div class="card-header">
              <a href="{{route('admin.faqs.create-faq-category')}}" class="btn btn-primary btn-sm float-end">Create Category</a>
          </div>
          <div class="card-body">
              <table class="table" id="faqCategoriesList">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Description</th>
                    <th>Actions</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach ($categories as $key => $category)
                    <tr>
                      <td>{{$key + 1}}</td>
                      <td>{{$category->title}}</td>
                      <td>{{$category->description}}</td>
                      <td>
                        <div>
                          <ul class="action">
                            <li class="edit"><a href="{{route('admin.faqs.update-faq-category-view', ['id'=>$category->id])}}" class="btn-link"><i class="icon-pencil-alt"></i></a></li>
                            <li class="delete"><a onclick="return confirmDelete();" href="{{route('admin.faqs.delete-faq-category', ['id'=>$category->id])}}" class="btn-link"><i class="icon-trash"></i></a></li>
                          </ul>
                        </div>
                      </td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
      </div>
	   </div>
	</div>
</div>
@endsection

@section('script')
  <script>
    $("#faqCategoriesList").DataTable();
    function confirmDelete(){
      return confirm('Are you sure you want to delete this category?');
    }
  </script>
@endsection
